/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j.base;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.fuin.serialver4j.base.ClassVersion;
import org.fuin.serialver4j.base.ClassesHistory;
import org.fuin.serialver4j.base.ContentNotFoundException;
import org.fuin.serialver4j.base.VersionedClass;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("Cannot create an instance of a utility class!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, ClassesHistory history) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            XStream xstream = Utils.createConfiguredXStream();
            xstream.toXML((Object)history, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassesHistory readFromFile(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            XStream xstream = Utils.createConfiguredXStream();
            ClassesHistory classesHistory = (ClassesHistory)xstream.fromXML((InputStream)in);
            return classesHistory;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static long getSerialVersionUID(Class<?> clasz) {
        try {
            Field field = clasz.getDeclaredField("serialVersionUID");
            field.setAccessible(true);
            return (Long)field.get(null);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("The class has no explicit serialVersionUID: " + clasz.getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getContent(String str, String beginTag, String endTag) throws ContentNotFoundException {
        Utils.assertNotNull("str", str);
        Utils.assertNotNull("beginTag", beginTag);
        Utils.assertNotNull("endTag", endTag);
        int startPos = str.indexOf(beginTag);
        if (startPos == -1) {
            throw new ContentNotFoundException("Begin tag not found: '" + beginTag + "'");
        }
        int endPos = str.indexOf(endTag, startPos + beginTag.length());
        if (endPos == -1) {
            throw new ContentNotFoundException("End tag not found: '" + endTag + "'");
        }
        return str.substring(startPos + beginTag.length(), endPos);
    }

    public static long getLongContent(String str, String beginTag, String endTag) throws ContentNotFoundException {
        String value = Utils.getContent(str, beginTag, endTag);
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw new ContentNotFoundException("The content between '" + beginTag + "' and '" + endTag + "' is not a long value: '" + value + "'");
        }
    }

    private static final void assertNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument '" + name + "' cannot be null!");
        }
    }

    public static XStream createConfiguredXStream() {
        XStream xstream = new XStream();
        xstream.alias("history", ClassesHistory.class);
        xstream.useAttributeFor(ClassesHistory.class, "versionTag");
        xstream.alias("class", VersionedClass.class);
        xstream.useAttributeFor(VersionedClass.class, "packageName");
        xstream.aliasField("package", VersionedClass.class, "packageName");
        xstream.useAttributeFor(VersionedClass.class, "className");
        xstream.aliasField("name", VersionedClass.class, "className");
        xstream.alias("version", ClassVersion.class);
        xstream.aliasField("oldClass", ClassVersion.class, "className");
        xstream.aliasField("converterClass", ClassVersion.class, "converterClassName");
        xstream.addImplicitCollection(ClassesHistory.class, "versionedClasses");
        xstream.addImplicitCollection(VersionedClass.class, "versions");
        return xstream;
    }
}

