/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fuin.serialver4j.base.Converter;
import org.fuin.serialver4j.base.ConverterFactory;
import org.fuin.serialver4j.base.VersionedClass;

public final class ClassesHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String versionTag = "version";
    private List<VersionedClass> versionedClasses;
    private transient ConverterFactory converterFactory;
    private transient Map<String, VersionedClass> nameMap;
    private transient Map<Class<?>, Converter<?, ?>> classMap;

    public ClassesHistory(ConverterFactory converterFactory) {
        this("version", converterFactory);
    }

    public ClassesHistory(String versionTag, ConverterFactory converterFactory) {
        this.versionTag = versionTag;
        this.converterFactory = converterFactory;
        this.versionedClasses = new ArrayList<VersionedClass>();
        this.nameMap = new HashMap<String, VersionedClass>();
        this.classMap = new HashMap();
    }

    public final void init(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
        this.nameMap = new HashMap<String, VersionedClass>();
        this.classMap = new HashMap();
        for (VersionedClass versionedClass : this.versionedClasses) {
            versionedClass.init();
            this.addToMaps(versionedClass);
        }
    }

    public final ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    private void addToMaps(VersionedClass versionedClass) {
        this.nameMap.put(versionedClass.getName(), versionedClass);
        List<Class<?>> archivedClasses = versionedClass.getArchivedClasses();
        for (Class<?> archivedClass : archivedClasses) {
            String converterName = archivedClass.getName() + "Converter";
            this.classMap.put(archivedClass, this.converterFactory.createConverter(converterName));
        }
    }

    public final void add(VersionedClass versionedClass) {
        this.versionedClasses.add(versionedClass);
        this.addToMaps(versionedClass);
    }

    public final void remove(VersionedClass versionedClass) {
        this.versionedClasses.remove(versionedClass);
        this.nameMap.remove(versionedClass.getName());
    }

    public final VersionedClass findVersionedClass(String name) {
        return this.nameMap.get(name);
    }

    public final Converter<? extends Object, ? extends Object> findConverter(Class<?> oldClass) {
        return this.classMap.get(oldClass);
    }

    public final String getVersionTag() {
        return this.versionTag;
    }
}

