/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j.hessian;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.fuin.serialver4j.base.ClassesHistory;
import org.fuin.serialver4j.base.DeserializationException;
import org.fuin.serialver4j.hessian.AbstractVersioningHessianSerializer;

public final class VersioningBurlapSerializer
extends AbstractVersioningHessianSerializer {
    public VersioningBurlapSerializer(ClassesHistory history) {
        super(history, 512, new SerializerFactory());
    }

    public VersioningBurlapSerializer(ClassesHistory history, SerializerFactory serializerFactory) {
        super(history, 512, serializerFactory);
    }

    public VersioningBurlapSerializer(ClassesHistory history, int pushbackBufSize, SerializerFactory serializerFactory) {
        super(history, pushbackBufSize, serializerFactory);
    }

    @Override
    public final Object deserialize(InputStream in) throws IOException, DeserializationException {
        PushbackInputStream pushbackIn = new PushbackInputStream(in, this.getPushbackBufSize());
        byte[] buf = new byte[this.getPushbackBufSize()];
        int count = pushbackIn.read(buf);
        pushbackIn.unread(buf, 0, count);
        BurlapInput input = new BurlapInput((InputStream)new ByteArrayInputStream(buf, 0, count));
        input.readMapStart();
        String type = input.readType();
        String tagName = input.readString();
        if (!tagName.equals(this.getVersionTag())) {
            throw new DeserializationException("Expected tag '" + this.getVersionTag() + "' but found: " + tagName);
        }
        long version = input.readLong();
        return this.readObject((AbstractHessianInput)new BurlapInput((InputStream)pushbackIn), version, type);
    }

    @Override
    public final void serialize(OutputStream out, Object obj) throws IOException {
        this.serialize((AbstractHessianOutput)new BurlapOutput(out), obj);
    }
}

