/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j.base;

import com.google.common.base.Predicate;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.fuin.serialver4j.base.Archived;
import org.fuin.serialver4j.base.ClassVersion;
import org.fuin.serialver4j.base.ClassesHistory;
import org.fuin.serialver4j.base.ConverterFactory;
import org.fuin.serialver4j.base.Utils;
import org.fuin.serialver4j.base.VersionedClass;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public final class ArchivedHistoryBuilder {
    private ArchivedHistoryBuilder() {
        throw new UnsupportedOperationException("Cannot create an instance of a utility class!");
    }

    public static ClassesHistory create(String versionTag, ConverterFactory converterFactory, String packageName) {
        ClassesHistory history = new ClassesHistory(versionTag, converterFactory);
        Reflections reflections = ArchivedHistoryBuilder.createReflections(packageName);
        Set archivedClasses = reflections.getTypesAnnotatedWith(Archived.class);
        for (Class archivedClass : archivedClasses) {
            Archived archived = archivedClass.getAnnotation(Archived.class);
            VersionedClass versionedClass = history.findVersionedClass(archived.clasz().getName());
            if (versionedClass == null) {
                versionedClass = new VersionedClass(archived.clasz().getPackage().getName(), archived.clasz().getSimpleName());
                history.add(versionedClass);
            }
            ClassVersion classVersion = new ClassVersion(Utils.getSerialVersionUID(archivedClass), archivedClass.getName(), archived.converter().getName());
            versionedClass.addVersion(classVersion);
        }
        return history;
    }

    private static Reflections createReflections(String packageName) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        Set<URL> urls = ArchivedHistoryBuilder.getUrls(packageName);
        configurationBuilder.setUrls(urls);
        configurationBuilder.setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
        FilterBuilder filterBuilder = new FilterBuilder();
        filterBuilder.include(FilterBuilder.prefix((String)packageName));
        configurationBuilder.filterInputsBy((Predicate)filterBuilder);
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        return reflections;
    }

    private static Set<URL> getUrls(String packageName) {
        HashSet<URL> urls = new HashSet<URL>();
        String packagePath = packageName.replace('.', '/');
        int packageLen = packagePath.length();
        Set foundUrls = ClasspathHelper.getUrlsForPackagePrefix((String)packageName);
        for (URL url : foundUrls) {
            String urlStr = url.toString();
            if (urlStr.endsWith(packagePath)) {
                try {
                    URL newUrl = new URL(urlStr.substring(0, urlStr.length() - packageLen));
                    urls.add(newUrl);
                    continue;
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            urls.add(url);
        }
        return urls;
    }
}

