/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import org.fuin.serialver4j.base.ClassesHistory;
import org.fuin.serialver4j.base.ContentNotFoundException;
import org.fuin.serialver4j.base.DeserializationException;
import org.fuin.serialver4j.base.Utils;
import org.fuin.serialver4j.base.VersioningSerializer;

public final class VersioningXStreamSerializer
implements VersioningSerializer {
    private final ClassesHistory history;
    private final XStream xstream;
    private final int pushbackBufSize;

    public VersioningXStreamSerializer(ClassesHistory history, XStream xstream, int pushbackBufSize) {
        this.history = history;
        this.xstream = xstream;
        this.pushbackBufSize = pushbackBufSize;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final Object deserialize(InputStream in) throws IOException, DeserializationException {
        pushbackIn = new PushbackInputStream(in, this.pushbackBufSize);
        buf = new byte[this.pushbackBufSize];
        count = pushbackIn.read(buf);
        pushbackIn.unread(buf, 0, count);
        str = new String(buf, 0, count, "UTF-8");
        try {
            version = Utils.getLongContent(str, "<" + this.history.getVersionTag() + ">", "</" + this.history.getVersionTag() + ">");
        }
        catch (ContentNotFoundException ex) {
            throw new DeserializationException("Error reading the '" + this.history + "' tag", ex);
        }
        try {
            type = Utils.getContent(str, "<", ">");
        }
        catch (ContentNotFoundException ex) {
            throw new DeserializationException("Error reading the type", ex);
        }
        reader = new InputStreamReader((InputStream)pushbackIn, "UTF-8");
        versionedClass = this.history.findVersionedClass(type);
        if (versionedClass == null) {
            return this.xstream.fromXML((Reader)reader);
        }
        archivedClass = versionedClass.findArchivedClass(version);
        if (archivedClass == null) {
            return this.xstream.fromXML((Reader)reader);
        }
        this.xstream.alias(type, archivedClass);
        obj = this.xstream.fromXML((Reader)reader);
        if (archivedClass.isInstance(obj)) ** GOTO lbl28
        throw new IllegalStateException("Expected class '" + archivedClass.getName() + "', but was:" + obj.getClass().getName());
lbl-1000:
        // 1 sources

        {
            obj = converter.convert(obj);
lbl28:
            // 2 sources

            ** while ((converter = this.history.findConverter(obj.getClass())) != null)
        }
lbl29:
        // 1 sources

        return obj;
    }

    @Override
    public final void serialize(OutputStream out, Object obj) throws IOException {
        this.xstream.marshal(obj, (HierarchicalStreamWriter)new CompactWriter((Writer)new OutputStreamWriter(out, "UTF-8")));
    }
}

