/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j.hessian;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.fuin.serialver4j.base.ClassesHistory;
import org.fuin.serialver4j.base.DeserializationException;
import org.fuin.serialver4j.hessian.AbstractVersioningHessianSerializer;

public final class VersioningHessian2Serializer
extends AbstractVersioningHessianSerializer {
    public VersioningHessian2Serializer(ClassesHistory history) {
        super(history, 512, new SerializerFactory());
    }

    public VersioningHessian2Serializer(ClassesHistory history, SerializerFactory serializerFactory) {
        super(history, 512, serializerFactory);
    }

    public VersioningHessian2Serializer(ClassesHistory history, int pushbackBufSize, SerializerFactory serializerFactory) {
        super(history, pushbackBufSize, serializerFactory);
    }

    @Override
    public final Object deserialize(InputStream in) throws IOException, DeserializationException {
        PushbackInputStream pushbackIn = new PushbackInputStream(in, this.getPushbackBufSize());
        byte[] buf = new byte[this.getPushbackBufSize()];
        int count = pushbackIn.read(buf);
        pushbackIn.unread(buf, 0, count);
        Hessian2Input input = new Hessian2Input((InputStream)new ByteArrayInputStream(buf, 0, count));
        int tag = input.read();
        if (tag != 79) {
            throw new DeserializationException("Expected 'O' but found: '" + tag + "'");
        }
        String type = input.readString();
        int len = input.readInt();
        int i = 0;
        while (i < len) {
            String fieldName = input.readString();
            if (i == 0 && !fieldName.equals(this.getVersionTag())) {
                throw new DeserializationException("Expected '" + this.getVersionTag() + "' as first field, but found: '" + fieldName + "'");
            }
            ++i;
        }
        tag = (char)input.read();
        if (tag != 111) {
            throw new DeserializationException("Expected 'o' but found: '" + tag + "'");
        }
        tag = input.read();
        if (tag != 144) {
            throw new DeserializationException("Expected '0x90' but found: '" + tag + "'");
        }
        long version = input.readLong();
        Hessian2Input hessian2Input = new Hessian2Input((InputStream)pushbackIn);
        try {
            Object object = this.readObject((AbstractHessianInput)hessian2Input, version, type);
            return object;
        }
        finally {
            hessian2Input.close();
        }
    }

    @Override
    public final void serialize(OutputStream out, Object obj) throws IOException {
        Hessian2Output hessian2Outpout = new Hessian2Output(out);
        try {
            this.serialize((AbstractHessianOutput)hessian2Outpout, obj);
        }
        finally {
            hessian2Outpout.close();
        }
    }
}

