/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.fuin.serialver4j.ClassesHistory;
import org.fuin.serialver4j.Converter;
import org.fuin.serialver4j.VersionedClass;

public final class VersioningObjectInputStream
extends ObjectInputStream {
    private ClassesHistory history;

    public VersioningObjectInputStream(ClassesHistory history, InputStream in) throws IOException {
        super(in);
        this.history = history;
        this.enableResolveObject(true);
    }

    @Override
    protected final Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        VersionedClass versionedClass = this.history.findVersionedClass(desc.getName());
        if (versionedClass == null) {
            return super.resolveClass(desc);
        }
        Class<?> archivedClass = versionedClass.findArchivedClass(desc.getSerialVersionUID());
        if (archivedClass == null) {
            return super.resolveClass(desc);
        }
        return super.resolveClass(ObjectStreamClass.lookup(archivedClass));
    }

    @Override
    protected final Object resolveObject(Object object) throws IOException {
        Converter<? extends Object, ? extends Object> converter;
        Object obj = object;
        while ((converter = this.history.findConverter(obj.getClass())) != null) {
            obj = converter.convert(obj);
        }
        return super.resolveObject(obj);
    }
}

