/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.fuin.serialver4j.AbstractVersioningHessianSerializer;
import org.fuin.serialver4j.ClassesHistory;
import org.fuin.serialver4j.DeserializationException;

public final class VersioningHessianSerializer
extends AbstractVersioningHessianSerializer {
    public VersioningHessianSerializer(ClassesHistory history) {
        super(history, 512, new SerializerFactory());
    }

    public VersioningHessianSerializer(ClassesHistory history, SerializerFactory serializerFactory) {
        super(history, 512, serializerFactory);
    }

    public VersioningHessianSerializer(ClassesHistory history, int pushbackBufSize, SerializerFactory serializerFactory) {
        super(history, pushbackBufSize, serializerFactory);
    }

    @Override
    public final Object deserialize(InputStream in) throws IOException, DeserializationException {
        PushbackInputStream pushbackIn = new PushbackInputStream(in, this.getPushbackBufSize());
        byte[] buf = new byte[this.getPushbackBufSize()];
        int count = pushbackIn.read(buf);
        pushbackIn.unread(buf, 0, count);
        HessianInput input = new HessianInput((InputStream)new ByteArrayInputStream(buf, 0, count));
        input.readMapStart();
        String type = input.readType();
        String tagName = input.readString();
        if (!tagName.equals(this.getVersionTag())) {
            throw new DeserializationException("Expected tag '" + this.getVersionTag() + "' but found: " + tagName);
        }
        long version = input.readLong();
        HessianInputExt hessianInput = new HessianInputExt(pushbackIn);
        try {
            Object object = this.readObject((AbstractHessianInput)hessianInput, version, type);
            return object;
        }
        finally {
            hessianInput.close();
        }
    }

    @Override
    public final void serialize(OutputStream out, Object obj) throws IOException {
        HessianOutput hessianOutput = new HessianOutput(out);
        try {
            this.serialize((AbstractHessianOutput)hessianOutput, obj);
        }
        finally {
            hessianOutput.close();
        }
    }

    private static class HessianInputExt
    extends HessianInput {
        private String replaceType;

        public HessianInputExt(InputStream is) {
            super(is);
        }

        public Object readObject(Class clasz) throws IOException {
            this.replaceType = clasz.getName();
            try {
                Object object = super.readObject(clasz);
                return object;
            }
            finally {
                this.replaceType = null;
            }
        }

        public String readType() throws IOException {
            if (this.replaceType == null) {
                return super.readType();
            }
            super.readType();
            return this.replaceType;
        }
    }
}

