/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fuin.serialver4j.ClassVersion;

public final class VersionedClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String packageName;
    private String className;
    private List<ClassVersion> versions;
    private transient Map<Long, Class<?>> versionMap;

    public VersionedClass(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
        this.versions = new ArrayList<ClassVersion>();
        this.versionMap = new HashMap();
    }

    public final void init() {
        this.versionMap = new HashMap();
        for (ClassVersion version : this.versions) {
            this.addToMap(version);
        }
    }

    private void addToMap(ClassVersion version) {
        this.versionMap.put(version.getSerialVersionUID(), this.classFor(version));
    }

    public final void addVersion(ClassVersion version) {
        this.versions.add(version);
        this.addToMap(version);
    }

    public final void removeVersion(ClassVersion version) {
        this.versions.remove(version);
        this.versionMap.remove(version.getSerialVersionUID());
    }

    public final String getName() {
        return String.valueOf(this.packageName) + "." + this.className;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getSimpleClassName() {
        return this.className;
    }

    public int hashCode() {
        String name = this.getName();
        int prime = 31;
        int result = 1;
        result = 31 * result + (name == null ? 0 : name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        String name = this.getName();
        VersionedClass other = (VersionedClass)obj;
        return !(name == null ? other.getName() != null : !name.equals(other.getName()));
    }

    public final Class<?> findArchivedClass(Long serialVersionUID) {
        return this.versionMap.get(serialVersionUID);
    }

    public final List<Class<?>> getArchivedClasses() {
        ArrayList classes = new ArrayList();
        for (ClassVersion version : this.versions) {
            classes.add(this.classFor(version));
        }
        return classes;
    }

    public Class<?> classFor(ClassVersion version) {
        String className = version.getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Cannot find archived class!", ex);
        }
    }

    public final String toString() {
        return this.getName();
    }

    final Map<Long, Class<?>> getVersionMap() {
        if (this.versionMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.versionMap);
    }
}

