/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.lang.reflect.Field;
import java.util.Locale;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Ensures;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Requires;
import org.fuin.objects4j.TextField;

@Immutable
public class TextFieldInfo {
    private final Field field;
    private final int width;

    @Requires(value="(field != null) && (width != null)")
    public TextFieldInfo(Field field, int width) {
        Contract.requireArgNotNull("field", field);
        Contract.requireArgNotNull("width", width);
        this.field = field;
        this.width = width;
    }

    @Ensures(value="\result != null")
    public final Field getField() {
        return this.field;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextFieldInfo other = (TextFieldInfo)obj;
        return this.field.equals(other.field);
    }

    @Requires(value="(field != null) && (locale!=null)")
    public static TextFieldInfo create(Field field, Locale locale) {
        TextField textField = field.getAnnotation(TextField.class);
        if (textField == null) {
            return null;
        }
        return new TextFieldInfo(field, textField.width());
    }
}

