/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Ensures;
import org.fuin.objects4j.FontSize;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.LabelFieldInfo;
import org.fuin.objects4j.Requires;
import org.fuin.objects4j.TableColumn;

@Immutable
public final class TableColumnInfo
implements Comparable<TableColumnInfo> {
    private final Field field;
    private final String text;
    private final String shortText;
    private final FontSize width;
    private final int pos;
    private final String getter;

    @Requires(value="(field != null) && (width != null) && (getter!=null)")
    public TableColumnInfo(Field field, String text, String shortText, int pos, FontSize width, String getter) {
        Contract.requireArgNotNull("field", field);
        Contract.requireArgNotNull("width", width);
        Contract.requireArgNotNull("getter", getter);
        this.field = field;
        this.text = text;
        this.shortText = shortText;
        this.pos = pos;
        this.width = width;
        this.getter = getter;
    }

    @Ensures(value="\result != null")
    public final Field getField() {
        return this.field;
    }

    public final String getText() {
        return this.text;
    }

    public final String getShortText() {
        return this.shortText;
    }

    public final FontSize getWidth() {
        return this.width;
    }

    public final int getPos() {
        return this.pos;
    }

    @Ensures(value="\result != null")
    public final String getGetter() {
        return this.getter;
    }

    @Override
    public final int compareTo(TableColumnInfo theOther) {
        if (this.pos > theOther.pos) {
            return 1;
        }
        if (this.pos < theOther.pos) {
            return -1;
        }
        return 0;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableColumnInfo other = (TableColumnInfo)obj;
        return this.field.equals(other.field);
    }

    @Requires(value="(clasz != null) && (locale!=null)")
    public static List<TableColumnInfo> create(Class<?> clasz, Locale locale) {
        Contract.requireArgNotNull("clasz", clasz);
        Contract.requireArgNotNull("locale", locale);
        ArrayList<TableColumnInfo> list = new ArrayList<TableColumnInfo>();
        Field[] fields = clasz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            TableColumnInfo tableColumnInfo = TableColumnInfo.create(fields[i], locale);
            if (tableColumnInfo == null) continue;
            list.add(tableColumnInfo);
        }
        Collections.sort(list);
        return list;
    }

    @Requires(value="(field != null) && (locale!=null)")
    public static TableColumnInfo create(Field field, Locale locale) {
        Contract.requireArgNotNull("field", field);
        Contract.requireArgNotNull("locale", locale);
        TableColumn tableColumn = field.getAnnotation(TableColumn.class);
        if (tableColumn == null) {
            return null;
        }
        LabelFieldInfo labelInfo = LabelFieldInfo.create(field, locale);
        int pos = tableColumn.pos();
        FontSize fontSize = new FontSize(tableColumn.width(), tableColumn.unit());
        String getter = TableColumnInfo.getGetter(tableColumn, field.getName());
        return new TableColumnInfo(field, labelInfo.getTextOrField(), labelInfo.getShortText(), pos, fontSize, getter);
    }

    private static String getGetter(TableColumn tableColumn, String fieldName) {
        if (tableColumn.getter().equals("")) {
            return "get" + TableColumnInfo.firstCharUpper(fieldName);
        }
        return tableColumn.getter();
    }

    private static String firstCharUpper(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return "" + Character.toUpperCase(str.charAt(0));
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

