/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.LabelClassInfo;
import org.fuin.objects4j.RenderFieldInfo;
import org.fuin.objects4j.Requires;

@Immutable
public final class RenderClassInfo<T> {
    private final Class<T> clasz;
    private final LabelClassInfo labelClassInfo;
    private final List<RenderFieldInfo> renderFields;

    @Requires(value="clasz != null")
    public RenderClassInfo(Class<T> clasz, Locale locale) {
        Field[] fields;
        Contract.requireArgNotNull("clasz", clasz);
        this.clasz = clasz;
        this.labelClassInfo = LabelClassInfo.create(clasz, locale);
        this.renderFields = new ArrayList<RenderFieldInfo>();
        for (Field field : fields = clasz.getDeclaredFields()) {
            this.renderFields.add(RenderFieldInfo.create(field, locale));
        }
    }

    public final Class<?> getClasz() {
        return this.clasz;
    }

    public final LabelClassInfo getLabelClassInfo() {
        return this.labelClassInfo;
    }

    public final List<RenderFieldInfo> getRenderFields() {
        return Collections.unmodifiableList(this.renderFields);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clasz.getName().hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenderClassInfo other = (RenderClassInfo)obj;
        return this.clasz.getName().equals(other.clasz.getName());
    }
}

