/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.AbstractStringBasedType;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Password;
import org.fuin.objects4j.Requires;
import org.fuin.objects4j.validation.PasswordSha512Str;

@Immutable
public final class PasswordSha512
extends AbstractStringBasedType<PasswordSha512> {
    private static final long serialVersionUID = -6285061339408965704L;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    @NotNull
    @PasswordSha512Str
    private final String hash;

    @Requires(value="hexEncodedHash!=null")
    public PasswordSha512(String hexEncodedHash) {
        this.hash = hexEncodedHash;
        Contract.requireValid(this);
    }

    @Requires(value="password!=null")
    public PasswordSha512(Password password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(password.toString().getBytes());
            this.hash = PasswordSha512.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("", ex);
        }
    }

    private static String toHex(byte[] hash) {
        int l = hash.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & hash[i]) >>> 4];
            out[j++] = DIGITS[0xF & hash[i]];
        }
        return String.copyValueOf(out);
    }

    @Override
    public final String toString() {
        return this.hash;
    }
}

