/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Label;
import org.fuin.objects4j.LabelInfo;
import org.fuin.objects4j.Requires;

@Immutable
public class LabelClassInfo
extends LabelInfo {
    private final Class<?> clasz;

    @Requires(value="clasz != null")
    public LabelClassInfo(Class<?> clasz, String text, String shortText) {
        super(text, shortText);
        Contract.requireArgNotNull("clasz", clasz);
        this.clasz = clasz;
    }

    public final Class<?> getClasz() {
        return this.clasz;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clasz.getName().hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelClassInfo other = (LabelClassInfo)obj;
        return this.clasz.getName().equals(other.clasz.getName());
    }

    @Requires(value="(clasz != null) && (locale != null)")
    public static LabelClassInfo create(Class<?> clasz, Locale locale) {
        Contract.requireArgNotNull("clasz", clasz);
        Contract.requireArgNotNull("locale", locale);
        Label label = clasz.getAnnotation(Label.class);
        if (label == null) {
            return null;
        }
        try {
            ResourceBundle bundle = LabelClassInfo.getResourceBundle(label, locale, clasz);
            String text = LabelClassInfo.getText(bundle, label, clasz.getSimpleName());
            String shortText = LabelClassInfo.getShortText(bundle, label, clasz.getSimpleName() + ".short");
            return new LabelClassInfo(clasz, text, shortText);
        }
        catch (MissingResourceException ex) {
            if (label.value().equals("")) {
                return new LabelClassInfo(clasz, null, null);
            }
            return new LabelClassInfo(clasz, label.value(), null);
        }
    }
}

