/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.fuin.objects4j.ContractViolationException;

public final class Contract {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();

    private Contract() {
        throw new UnsupportedOperationException("You cannot create an instance of a utility class!");
    }

    public static void requireArgNotNull(String name, Object value) throws ContractViolationException {
        if (value == null) {
            throw new ContractViolationException("The argument '" + name + "' cannot be null");
        }
    }

    public static void requireValid(Object value) throws ContractViolationException {
        Set constraintViolations = VALIDATOR.validate(value, new Class[0]);
        if (constraintViolations.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (ConstraintViolation constraintViolation : constraintViolations) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("[" + constraintViolation.getPropertyPath() + "] " + constraintViolation.getMessage() + " {" + constraintViolation.getInvalidValue() + "}");
            }
            throw new ContractViolationException(sb.toString(), constraintViolations);
        }
    }
}

