/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Ensures;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.LabelFieldInfo;
import org.fuin.objects4j.Requires;
import org.fuin.objects4j.TableColumnInfo;
import org.fuin.objects4j.TextFieldInfo;
import org.fuin.objects4j.validation.PasswordStr;

@Immutable
public final class RenderFieldInfo {
    private final Field field;
    private final LabelFieldInfo labelFieldInfo;
    private final TextFieldInfo textFieldInfo;
    private final TableColumnInfo tableColumnInfo;

    @Requires(value="field != null")
    public RenderFieldInfo(Field field, LabelFieldInfo labelFieldInfo, TextFieldInfo textFieldInfo, TableColumnInfo tableColumnInfo) {
        Contract.requireArgNotNull("field", field);
        this.field = field;
        this.labelFieldInfo = labelFieldInfo;
        this.textFieldInfo = textFieldInfo;
        this.tableColumnInfo = tableColumnInfo;
    }

    @Ensures(value="\result != null")
    public final Field getField() {
        return this.field;
    }

    public final LabelFieldInfo getLabelFieldInfo() {
        return this.labelFieldInfo;
    }

    public final TextFieldInfo getTextFieldInfo() {
        return this.textFieldInfo;
    }

    public final TableColumnInfo getTableColumnInfo() {
        return this.tableColumnInfo;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenderFieldInfo other = (RenderFieldInfo)obj;
        return this.field.equals(other.field);
    }

    public final boolean isPasswordField() {
        return this.field.getAnnotation(PasswordStr.class) != null;
    }

    public final boolean isRequired() {
        return true;
    }

    @Ensures(value="\result != null")
    public final String getLabelText() {
        if (this.labelFieldInfo == null) {
            return this.field.getName();
        }
        return this.labelFieldInfo.getTextOrField();
    }

    public final Long getMinLength() {
        Min min = this.find(Min.class);
        if (min == null) {
            Size size = this.find(Size.class);
            if (size == null) {
                return null;
            }
            return size.min();
        }
        return min.value();
    }

    public final Long getMaxLength() {
        Max max = this.find(Max.class);
        if (max == null) {
            Size size = this.find(Size.class);
            if (size == null) {
                return null;
            }
            return size.max();
        }
        return max.value();
    }

    public final <A extends Annotation> A find(Class<A> type) {
        return RenderFieldInfo.find(type, this.field.getAnnotations(), new ArrayList<Class<? extends Annotation>>());
    }

    public static <A extends Annotation> A find(Class<A> type, Annotation[] annotations, List<Class<? extends Annotation>> alreadyProcessed) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            Class<? extends Annotation> foundType = annotation.annotationType();
            if (alreadyProcessed.indexOf(foundType) == -1) {
                alreadyProcessed.add(foundType);
                if (annotation.annotationType().equals(type)) {
                    return (A)annotation;
                }
                A found = RenderFieldInfo.find(type, annotation.annotationType().getAnnotations(), alreadyProcessed);
                if (found != null) {
                    return found;
                }
            }
            ++n2;
        }
        return null;
    }

    @Ensures(value="\result != null")
    public static RenderFieldInfo create(Field field, Locale locale) {
        LabelFieldInfo labelFieldInfo = LabelFieldInfo.create(field, locale);
        TextFieldInfo textFieldInfo = TextFieldInfo.create(field, locale);
        TableColumnInfo tableColumnInfo = TableColumnInfo.create(field, locale);
        return new RenderFieldInfo(field, labelFieldInfo, textFieldInfo, tableColumnInfo);
    }
}

