/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Ensures;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Label;
import org.fuin.objects4j.Requires;

@Immutable
public abstract class LabelInfo {
    private final String text;
    private final String shortText;

    public LabelInfo(String text, String shortText) {
        this.text = text;
        this.shortText = shortText;
    }

    public final String getText() {
        return this.text;
    }

    public final String getShortText() {
        return this.shortText;
    }

    @Requires(value="(bundle != null) && (label != null) && (field!=null)")
    public static String getText(ResourceBundle bundle, Label label, String defaultKey) {
        Contract.requireArgNotNull("bundle", bundle);
        Contract.requireArgNotNull("label", label);
        Contract.requireArgNotNull("defaultKey", defaultKey);
        String key = label.key().equals("") ? defaultKey : label.key();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return LabelInfo.toNullableString(label.value());
        }
    }

    @Requires(value="(bundle != null) && (label != null) && (field!=null)")
    public static String getShortText(ResourceBundle bundle, Label label, String defaultKey) {
        Contract.requireArgNotNull("bundle", bundle);
        Contract.requireArgNotNull("label", label);
        Contract.requireArgNotNull("field", defaultKey);
        String key = label.shortKey().equals("") ? defaultKey : label.shortKey();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return LabelInfo.toNullableString(label.shortText());
        }
    }

    @Requires(value="(label != null) && (locale != null) && (clasz != null)")
    @Ensures(value="\result != null")
    public static ResourceBundle getResourceBundle(Label label, Locale locale, Class<?> clasz) {
        if (label.bundle().equals("")) {
            String path = clasz.getPackage().getName().replace('.', '/');
            String baseName = String.valueOf(path) + "/" + clasz.getSimpleName();
            return ResourceBundle.getBundle(baseName, locale);
        }
        return ResourceBundle.getBundle(label.bundle(), locale);
    }

    protected static String toNullableString(String value) {
        if (value.equals("")) {
            return null;
        }
        return value;
    }
}

