/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Ensures;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Label;
import org.fuin.objects4j.LabelInfo;
import org.fuin.objects4j.Requires;

@Immutable
public final class LabelFieldInfo
extends LabelInfo {
    private final Field field;

    @Requires(value="field != null")
    public LabelFieldInfo(Field field, String text, String shortText) {
        super(text, shortText);
        Contract.requireArgNotNull("field", field);
        this.field = field;
    }

    @Ensures(value="\result != null")
    public final Field getField() {
        return this.field;
    }

    @Ensures(value="\result != null")
    public final String getTextOrField() {
        String text = this.getText();
        if (text == null) {
            return this.field.getName();
        }
        return text;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelFieldInfo other = (LabelFieldInfo)obj;
        return this.field.equals(other.field);
    }

    @Requires(value="(clasz != null) && (locale != null)")
    @Ensures(value="\result != null")
    public static List<LabelFieldInfo> create(Class<?> clasz, Locale locale) {
        Field[] fields;
        ArrayList<LabelFieldInfo> labelInfos = new ArrayList<LabelFieldInfo>();
        Field[] fieldArray = fields = clasz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Label label = field.getAnnotation(Label.class);
            if (label != null) {
                String shortText;
                String text;
                try {
                    ResourceBundle bundle = LabelFieldInfo.getResourceBundle(label, locale, field.getDeclaringClass());
                    text = LabelFieldInfo.getText(bundle, label, field.getName());
                    shortText = LabelFieldInfo.getShortText(bundle, label, String.valueOf(field.getName()) + ".short");
                    labelInfos.add(new LabelFieldInfo(field, text, shortText));
                }
                catch (MissingResourceException ex) {
                    text = LabelFieldInfo.toNullableString(label.value());
                    shortText = LabelFieldInfo.toNullableString(label.shortText());
                    labelInfos.add(new LabelFieldInfo(field, text, shortText));
                }
            }
            ++n2;
        }
        Class<?> parent = clasz;
        while ((parent = parent.getSuperclass()) != Object.class) {
            labelInfos.addAll(LabelFieldInfo.create(parent, locale));
        }
        return labelInfos;
    }

    @Requires(value="(field != null) && (locale != null)")
    public static LabelFieldInfo create(Field field, Locale locale) {
        Contract.requireArgNotNull("field", field);
        Contract.requireArgNotNull("locale", locale);
        Label label = field.getAnnotation(Label.class);
        if (label == null) {
            return null;
        }
        try {
            ResourceBundle bundle = LabelFieldInfo.getResourceBundle(label, locale, field.getDeclaringClass());
            String text = LabelFieldInfo.getText(bundle, label, field.getName());
            String shortText = LabelFieldInfo.getShortText(bundle, label, field.getName());
            return new LabelFieldInfo(field, text, shortText);
        }
        catch (MissingResourceException ex) {
            return new LabelFieldInfo(field, LabelFieldInfo.toNullableString(label.value()), LabelFieldInfo.toNullableString(label.shortText()));
        }
    }

    public String toString() {
        return this.field.getName();
    }
}

