/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.io.Serializable;
import java.text.DecimalFormat;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.FontSizeUnit;
import org.fuin.objects4j.Immutable;

@Immutable
public final class FontSize
implements Serializable {
    private static final long serialVersionUID = -1572749922357083439L;
    private final float size;
    @NotNull
    private final FontSizeUnit unit;

    public FontSize(float size, FontSizeUnit unit) {
        this.size = size;
        this.unit = unit;
        Contract.requireValid(this);
    }

    public final float getSize() {
        return this.size;
    }

    public final FontSizeUnit getUnit() {
        return this.unit;
    }

    public final int toPixel() {
        if (this.unit == FontSizeUnit.PIXEL) {
            return Math.round(this.size);
        }
        if (this.unit == FontSizeUnit.EM) {
            return Math.round(16.0f * this.size);
        }
        if (this.unit == FontSizeUnit.PERCENT) {
            return Math.round(this.size / 100.0f * 16.0f);
        }
        if (this.unit == FontSizeUnit.POINT) {
            return Math.round(this.size / 3.0f * 4.0f);
        }
        throw new IllegalStateException("Unknown unit: " + (Object)((Object)this.unit));
    }

    public final float toPoint() {
        if (this.unit == FontSizeUnit.PIXEL) {
            return this.size / 4.0f * 3.0f;
        }
        if (this.unit == FontSizeUnit.EM) {
            return this.size * 12.0f;
        }
        if (this.unit == FontSizeUnit.PERCENT) {
            return this.size / 100.0f * 12.0f;
        }
        if (this.unit == FontSizeUnit.POINT) {
            return this.size;
        }
        throw new IllegalStateException("Unknown unit: " + (Object)((Object)this.unit));
    }

    public final float toEm() {
        if (this.unit == FontSizeUnit.PIXEL) {
            return this.size / 16.0f;
        }
        if (this.unit == FontSizeUnit.EM) {
            return this.size;
        }
        if (this.unit == FontSizeUnit.PERCENT) {
            return this.size / 100.0f;
        }
        if (this.unit == FontSizeUnit.POINT) {
            return this.size / 12.0f;
        }
        throw new IllegalStateException("Unknown unit: " + (Object)((Object)this.unit));
    }

    public final float toPercent() {
        if (this.unit == FontSizeUnit.PIXEL) {
            return this.size / 16.0f * 100.0f + 1.0f;
        }
        if (this.unit == FontSizeUnit.EM) {
            return this.size * 100.0f;
        }
        if (this.unit == FontSizeUnit.PERCENT) {
            return this.size;
        }
        if (this.unit == FontSizeUnit.POINT) {
            return this.size / 12.0f * 100.0f;
        }
        throw new IllegalStateException("Unknown unit: " + (Object)((Object)this.unit));
    }

    public final String toPixelStr() {
        return String.valueOf(this.toPixel()) + "px";
    }

    public final String toPointStr() {
        return String.valueOf(new DecimalFormat("%.1f").format(this.toPoint())) + "pt";
    }

    public final String toEmStr() {
        return String.valueOf(new DecimalFormat("%.3f").format(this.toEm())) + "em";
    }

    public final String toPercentStr() {
        return String.valueOf(new DecimalFormat("%.1f").format(this.toPercent())) + "%";
    }

    public String toString() {
        if (this.unit == FontSizeUnit.PIXEL) {
            return this.toPixelStr();
        }
        if (this.unit == FontSizeUnit.EM) {
            return this.toEmStr();
        }
        if (this.unit == FontSizeUnit.PERCENT) {
            return this.toPercentStr();
        }
        if (this.unit == FontSizeUnit.POINT) {
            return this.toPointStr();
        }
        throw new IllegalStateException("Unknown unit: " + (Object)((Object)this.unit));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.size);
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontSize other = (FontSize)obj;
        if (Float.floatToIntBits(this.size) != Float.floatToIntBits(other.size)) {
            return false;
        }
        return this.unit.equals((Object)other.unit);
    }
}

