/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.objects4j;

import java.io.Serializable;

/**
 * Base class for immutable types that have {@link Object#hashCode()},
 * {@link Object#equals(Object)} and are comparable based on the
 * {@link Object#toString()} method.
 * 
 * @param <T>
 *            Concrete type.
 */
public abstract class AbstractStringBasedType<T> implements Comparable<T>, Serializable {

    private static final long serialVersionUID = 2301202805889581960L;

    @Override
    public final int hashCode() {
        return toString().hashCode();
    }

    @Override
    @SuppressWarnings("unchecked")
    public final boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final T other = (T) obj;
        return toString().equals(other.toString());
    }

    @Override
    public final int compareTo(final T obj) {
        final T other = (T) obj;
        return this.toString().compareTo(other.toString());
    }

    /**
     * Returns the length.
     * 
     * @return Number of characters.
     */
    public final int length() {
        return toString().length();
    }

    @Override
    public abstract String toString();

}
