/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.objects4j;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.fuin.objects4j.validation.PasswordStr;

/**
 * A password with a length between 8 and 20 characters.
 */
@Immutable
public final class Password implements Serializable {

    private static final long serialVersionUID = -7745110729063955842L;

    @NotNull
    @PasswordStr
    private final String password;

    /**
     * Constructor with password.
     * 
     * @param password
     *            Password.
     */
    @Requires("(password!=null) && ValidPasswordValidator.isValid(password)")
    public Password(final String password) {
        super();
        this.password = password;
        Contract.requireValid(this);
    }

    // CHECKSTYLE:OFF Generated hashCode + equals
    @Override
    public final int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((password == null) ? 0 : password.hashCode());
        return result;
    }

    @Override
    public final boolean equals(final Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Password other = (Password) obj;
        if (password == null) {
            if (other.password != null)
                return false;
        } else if (!password.equals(other.password))
            return false;
        return true;
    }

    // CHECKSTYLE:ON

    /**
     * Returns the length of the password.
     * 
     * @return Number of characters.
     */
    public final int length() {
        return password.length();
    }

    @Override
    public String toString() {
        return password;
    }

}
