/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Requires;
import org.fuin.objects4j.validation.UserNameStr;

@Immutable
public final class UserName
implements Comparable<UserName>,
Serializable {
    private static final long serialVersionUID = 9055520843135472634L;
    @NotNull
    @UserNameStr
    private final String userName;

    @Requires(value="(userName!=null) && ValidUserNameValidator.isValid(userName)")
    public UserName(String userName) {
        this.userName = userName.trim().toLowerCase();
        Contract.requireValid(this);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserName other = (UserName)obj;
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public final int length() {
        return this.userName.length();
    }

    @Override
    public final int compareTo(UserName obj) {
        UserName other = obj;
        return this.userName.compareTo(other.userName);
    }

    public String toString() {
        return this.userName;
    }
}

