/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Requires;
import org.fuin.objects4j.validation.UserIdStr;

@Immutable
public final class UserId
implements Comparable<UserId>,
Serializable {
    private static final long serialVersionUID = 9055520843135472634L;
    @NotNull
    @UserIdStr
    private final String userId;

    @Requires(value="(userId!=null) && ValidUserIdValidator.isValid(userId)")
    public UserId(String userId) {
        this.userId = userId.trim().toLowerCase();
        Contract.requireValid(this);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserId other = (UserId)obj;
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    public final int length() {
        return this.userId.length();
    }

    @Override
    public final int compareTo(UserId obj) {
        UserId other = obj;
        return this.userId.compareTo(other.userId);
    }

    public String toString() {
        return this.userId;
    }
}

