/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Password;
import org.fuin.objects4j.Requires;

@Immutable
public final class PasswordSha512
implements Serializable {
    private static final long serialVersionUID = -6285061339408965704L;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] hash;
    private transient String hashStr;

    @Requires(value="password!=null")
    public PasswordSha512(Password password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(password.toString().getBytes());
            this.hash = md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("", ex);
        }
    }

    public final String toString() {
        if (this.hashStr == null) {
            int l = this.hash.length;
            char[] out = new char[l << 1];
            int j = 0;
            int i = 0;
            while (i < l) {
                out[j++] = DIGITS[(0xF0 & this.hash[i]) >>> 4];
                out[j++] = DIGITS[0xF & this.hash[i]];
                ++i;
            }
            this.hashStr = String.copyValueOf(out);
        }
        return this.hashStr;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PasswordSha512 other = (PasswordSha512)obj;
        return Arrays.equals(this.hash, other.hash);
    }
}

