/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Requires;
import org.fuin.objects4j.validation.PasswordStr;

@Immutable
public final class Password
implements Serializable {
    private static final long serialVersionUID = -7745110729063955842L;
    @NotNull
    @PasswordStr
    private final String password;

    @Requires(value="(password!=null) && ValidPasswordValidator.isValid(password)")
    public Password(String password) {
        this.password = password;
        Contract.requireValid(this);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Password other = (Password)obj;
        return !(this.password == null ? other.password != null : !this.password.equals(other.password));
    }

    public final int length() {
        return this.password.length();
    }

    public String toString() {
        return this.password;
    }
}

