/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.Contract;
import org.fuin.objects4j.Immutable;
import org.fuin.objects4j.Requires;
import org.fuin.objects4j.validation.EmailAddressStr;

@Immutable
public final class EmailAddress
implements Comparable<EmailAddress>,
Serializable {
    private static final long serialVersionUID = -7976802296383690770L;
    @NotNull
    @EmailAddressStr
    private final String emailAddress;

    @Requires(value="(emailAddress!=null) && ValidEmailAddressValidator.isValid(emailAddress)")
    public EmailAddress(String emailAddress) {
        this.emailAddress = emailAddress.trim().toLowerCase();
        Contract.requireValid(this);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmailAddress other = (EmailAddress)obj;
        return !(this.emailAddress == null ? other.emailAddress != null : !this.emailAddress.equals(other.emailAddress));
    }

    @Override
    public final int compareTo(EmailAddress obj) {
        EmailAddress other = obj;
        return this.emailAddress.compareTo(other.emailAddress);
    }

    public final int length() {
        return this.emailAddress.length();
    }

    public final String toString() {
        return this.emailAddress;
    }
}

