/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public final class Contract {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();

    private Contract() {
        throw new UnsupportedOperationException("You cannot create an instance of a utility class!");
    }

    public static <T> void requireValid(T value) {
        Set constraintViolations = VALIDATOR.validate(value, new Class[0]);
        if (constraintViolations.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (ConstraintViolation constraintViolation : constraintViolations) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("[" + constraintViolation.getPropertyPath() + "] " + constraintViolation.getMessage() + " {" + constraintViolation.getInvalidValue() + "}");
            }
            throw new IllegalStateException(sb.toString());
        }
    }
}

