/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.fuin.utils4j.Cancelable;
import org.fuin.utils4j.CancelableVolatile;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.common.Utils4Swing;
import org.fuin.utils4swing.progress.FileCopyProgressInputStream;
import org.fuin.utils4swing.progress.FileCopyProgressListener;
import org.fuin.utils4swing.progress.FileCopyProgressMonitor;

public final class Utils {
    private static final Logger LOG = Logger.getLogger((Class)Utils.class);
    private static final Map XML_MAP = new HashMap();

    private Utils() {
        throw new UnsupportedOperationException("Creating instances is not allowed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(FileCopyProgressListener listener, URL srcFileUrl, File destFile, int fileNo, int fileSize) throws FileNotFoundException {
        if (listener != null) {
            listener.updateFile(srcFileUrl.toString(), destFile.toString(), fileNo, fileSize);
        }
        try {
            FileCopyProgressInputStream input = new FileCopyProgressInputStream(listener, srcFileUrl.openStream(), fileSize);
            try {
                FileOutputStream output = FileUtils.openOutputStream((File)destFile);
                try {
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void unzip(final FileCopyProgressListener listener, final File zipFile, final int zipFileNo, File destDir, Cancelable cancelable) {
        try {
            Utils4J.unzip((File)zipFile, (File)destDir, (Utils4J.UnzipInputStreamWrapper)new Utils4J.UnzipInputStreamWrapper(){

                public InputStream wrapInputStream(InputStream in, ZipEntry entry, File destFile) {
                    if (entry.getSize() > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Cannot handle files larger than 2147483647 bytes!");
                    }
                    if (listener != null) {
                        listener.updateFile(zipFile.toString(), destFile.toString(), zipFileNo, (int)entry.getSize());
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("UNZIP " + zipFile + " => " + destFile));
                    }
                    return new FileCopyProgressInputStream(listener, in, (int)entry.getSize());
                }
            }, (Cancelable)cancelable);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void copyURLToFile(String url, File file) {
        try {
            FileUtils.copyURLToFile((URL)new URL(url), (File)file);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error copying URL to file!", ex);
        }
    }

    public static final String escapeXml(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String entityName = (String)XML_MAP.get("" + c);
            if (entityName == null) {
                if (c > '\u007f') {
                    sb.append("&#");
                    sb.append(Integer.toString(c, 10));
                    sb.append(';');
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append('&');
            sb.append(entityName);
            sb.append(';');
        }
        return sb.toString();
    }

    public static boolean nullSafeEquals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Utils4Swing.initSystemLookAndFeel();
        CancelableVolatile cancelable = new CancelableVolatile();
        ArrayList<File> zipFiles = new ArrayList<File>();
        zipFiles.add(new File("C:\\test.zip"));
        FileCopyProgressMonitor monitor = new FileCopyProgressMonitor((Cancelable)cancelable, "Unzip Test", zipFiles.size());
        monitor.open();
        try {
            long start = System.currentTimeMillis();
            for (int i = 0; i < zipFiles.size() && !cancelable.isCanceled(); ++i) {
                Utils.unzip((FileCopyProgressListener)monitor, (File)zipFiles.get(i), i + 1, new File("C:\\temp"), (Cancelable)cancelable);
            }
            System.out.println(System.currentTimeMillis() - start);
        }
        finally {
            monitor.close();
        }
    }

    static {
        XML_MAP.put("\"", "quot");
        XML_MAP.put("&", "amp");
        XML_MAP.put("<", "lt");
        XML_MAP.put(">", "gt");
        XML_MAP.put("'", "apos");
    }
}

