/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.fuin.kickstart4j.Config;
import org.fuin.kickstart4j.ConfigParser;
import org.fuin.kickstart4j.ConfigUpdaterListener;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.RemoteFile;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.utils4j.Utils4J;

public final class ConfigUpdater {
    private final Config config;
    private final ConfigUpdaterListener listener;

    public ConfigUpdater() {
        this.config = new Config();
        this.listener = new DefaultListener();
    }

    public ConfigUpdater(ConfigUpdaterListener listener) {
        this.config = new Config();
        Utils4J.checkNotNull((String)"listener", (Object)listener);
        this.listener = listener;
    }

    public ConfigUpdater(File configFile) throws InvalidConfigException {
        this(configFile, new DefaultListener());
    }

    public ConfigUpdater(File configFile, ConfigUpdaterListener listener) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"configFile", (Object)configFile);
        Utils4J.checkValidFile((File)configFile);
        this.config = ConfigParser.create(configFile);
        Utils4J.checkNotNull((String)"listener", (Object)listener);
        this.listener = listener;
    }

    private void copyToFile(RemoteFile remoteFile, File file, int nr, int max) throws IOException {
        try {
            FileUtils.copyURLToFile((URL)remoteFile.getSrcFileUrl(), (File)file);
            this.listener.onCopy(remoteFile, file, nr, max);
        }
        catch (FileNotFoundException ex) {
            if (remoteFile.isErrorIfNotFound()) {
                throw ex;
            }
            this.listener.onNotFound(remoteFile, file, nr, max);
        }
    }

    private SrcFile findSrcFile(List srcFiles, RemoteFile remoteFile) {
        for (int i = 0; i < srcFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)srcFiles.get(i);
            if (!remoteFile.getDestSlashPath().equals(srcFile.getSlashPath()) || !remoteFile.getDestFilename().equals(srcFile.getFilename())) continue;
            return srcFile;
        }
        return null;
    }

    public final void update(List remoteFileList) throws IOException {
        ArrayList oldSrcFiles = new ArrayList();
        oldSrcFiles.addAll(this.config.getSrcFiles());
        this.config.getSrcFiles().clear();
        File localFile = File.createTempFile("kickstart4j-config-creator-", ".tmp");
        int size = remoteFileList.size();
        for (int i = 0; i < size; ++i) {
            RemoteFile remoteFile = (RemoteFile)remoteFileList.get(i);
            this.copyToFile(remoteFile, localFile, i + 1, size);
            SrcFile oldSrcFile = this.findSrcFile(oldSrcFiles, remoteFile);
            SrcFile newSrcFile = oldSrcFile == null ? new SrcFile(remoteFile.getDestPath(), remoteFile.getDestFilename(), Utils4J.createHashMD5((File)localFile), localFile.length(), false, false, false, remoteFile.getSrcFileUrl().toExternalForm(), 0) : new SrcFile(remoteFile.getDestPath(), remoteFile.getDestFilename(), Utils4J.createHashMD5((File)localFile), localFile.length(), oldSrcFile.isUnzip(), oldSrcFile.isLoadAlways(), oldSrcFile.isAddToClasspath(), remoteFile.getSrcFileUrl().toExternalForm(), oldSrcFile.getOrder());
            this.config.getSrcFiles().add(newSrcFile);
        }
        localFile.delete();
    }

    private static void addSrcFiles(File baseDir, File dir, List remoteFiles) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ConfigUpdater.addSrcFiles(baseDir, files[i], remoteFiles);
                continue;
            }
            String path = ConfigUpdater.getRelativePath(baseDir, dir);
            String filename = files[i].getName();
            try {
                RemoteFile remoteFile = new RemoteFile(files[i].toURI().toURL(), path, filename, false);
                remoteFiles.add(remoteFile);
                continue;
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static String getRelativePath(File baseDir, File dir) {
        return Utils4J.getRelativePath((File)baseDir, (File)dir).replace(File.separatorChar, '/');
    }

    private static List createRemoteFileList(File dir) {
        ArrayList remoteFiles = new ArrayList();
        ConfigUpdater.addSrcFiles(dir, dir, remoteFiles);
        return remoteFiles;
    }

    public final void update(File baseDir) throws IOException {
        List remoteFiles = ConfigUpdater.createRemoteFileList(baseDir);
        this.update(remoteFiles);
    }

    public final Config getConfig() {
        return this.config;
    }

    public final ConfigUpdaterListener getListener() {
        return this.listener;
    }

    public static void main(String[] args) throws InvalidConfigException, IOException {
        ConfigUpdater updater;
        if (args == null || args.length != 2) {
            System.out.println("java -classpath <CP> " + ConfigUpdater.class.getName() + " <CONFIG-FILE> <APP-DIR>");
            System.out.println("    <CONFIG-FILE> = Path and name of configuration file");
            System.out.println("    <APP-DIR> = Path and name of existing application directory");
            return;
        }
        File baseDir = new File(args[1]);
        Utils4J.checkValidDir((File)baseDir);
        File configFile = new File(args[0]);
        Utils4J.checkValidDir((File)configFile.getParentFile());
        if (configFile.exists()) {
            System.out.println("READ " + configFile);
            updater = new ConfigUpdater(configFile);
        } else {
            updater = new ConfigUpdater();
        }
        updater.update(baseDir);
        updater.getConfig().writeToVarXML(configFile, true);
        System.out.println("SAVED " + configFile);
    }

    private static final class DefaultListener
    implements ConfigUpdaterListener {
        private DefaultListener() {
        }

        public void onCopy(RemoteFile remoteFile, File file, int nr, int max) {
            System.out.println("COPY " + nr + "/" + max + ": " + remoteFile.getSrcFileUrl());
        }

        public void onNotFound(RemoteFile remoteFile, File file, int nr, int max) {
            System.out.println("NOT FOUND " + nr + "/" + max + ": " + remoteFile.getSrcFileUrl());
        }
    }
}

