/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.fuin.kickstart4j.CmdLineException;
import org.fuin.kickstart4j.CmdLineOption;
import org.fuin.kickstart4j.Config;
import org.fuin.kickstart4j.MessagesWrapper;

public final class CmdLineParser {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final List cmdLineOptions;
    private final Map options;
    private final MessagesWrapper messages;

    public CmdLineParser(Locale locale) {
        this.messages = new MessagesWrapper(locale);
        this.cmdLineOptions = CmdLineParser.createCommandLineOptions(this.messages);
        this.options = new HashMap();
    }

    public final void parse(String[] args) throws CmdLineException {
        List requiredKeys = this.createRequiredKeys();
        if (args == null || args.length == 0) {
            this.checkRequiredKeys(requiredKeys);
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                throw new CmdLineException(this.messages.getErrorOptionWithoutPrefix(arg));
            }
            String option = arg.substring(1);
            if (++i >= args.length) {
                throw new CmdLineException(this.messages.getErrorValueMissingForOption(option));
            }
            String value = args[i];
            this.options.put(option, value);
            int idx = requiredKeys.indexOf(option);
            if (idx <= -1) continue;
            requiredKeys.remove(idx);
        }
        this.checkRequiredKeys(requiredKeys);
    }

    public String get(String key) {
        return (String)this.options.get(key);
    }

    public String remove(String key) {
        return (String)this.options.remove(key);
    }

    public void copyToConfig(Config config) {
        Iterator it = this.options.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)this.options.get(key);
            if (key.equals("configFileUrl")) {
                config.setConfigFileUrl(value);
            }
            config.getCmdLineOptions().put(key, value);
        }
    }

    private List createRequiredKeys() {
        ArrayList<String> requiredKeys = new ArrayList<String>();
        for (int i = 0; i < this.cmdLineOptions.size(); ++i) {
            CmdLineOption option = (CmdLineOption)this.cmdLineOptions.get(i);
            if (!option.isRequired()) continue;
            requiredKeys.add(option.getKey());
        }
        return requiredKeys;
    }

    private void checkRequiredKeys(List requiredKeys) throws CmdLineException {
        if (requiredKeys.size() > 0) {
            StringBuffer sb = new StringBuffer(this.messages.getErrorMissingReuiredOptions());
            sb.append(" ");
            for (int i = 0; i < requiredKeys.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("-");
                sb.append(requiredKeys.get(i));
            }
            throw new CmdLineException(sb.toString());
        }
    }

    public final void printUsage(PrintStream ps) {
        for (int i = 0; i < this.cmdLineOptions.size(); ++i) {
            CmdLineOption option = (CmdLineOption)this.cmdLineOptions.get(i);
            ps.println(option.getOptionText(this.messages));
        }
    }

    public final void printUsage(OutputStream out) {
        for (int i = 0; i < this.cmdLineOptions.size(); ++i) {
            CmdLineOption option = (CmdLineOption)this.cmdLineOptions.get(i);
            String str = option.getOptionText(this.messages) + LINE_SEPARATOR;
            try {
                out.write(str.getBytes());
                continue;
            }
            catch (IOException ex) {
                throw new RuntimeException("Error printing usage on 'OutputStream'!", ex);
            }
        }
    }

    private static List createCommandLineOptions(MessagesWrapper msg) {
        ArrayList<CmdLineOption> list = new ArrayList<CmdLineOption>();
        list.add(new CmdLineOption("configFileUrl", "(URL)", msg.getOptionUsageConfigFileUrl(), true));
        return list;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.options.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)this.options.get(key);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(key);
            sb.append("='");
            sb.append(value);
            sb.append("'");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] arguments = new String[]{"-src", "http://www.fuin.org/test/", "-dest", "d:\\temp", "-idFilename", "myapp"};
        CmdLineParser parser = new CmdLineParser(Locale.getDefault());
        try {
            parser.parse(arguments);
            System.out.println(parser);
        }
        catch (CmdLineException ex) {
            ex.printStackTrace();
        }
    }
}

