/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.fuin.kickstart4j.AbstractFile;
import org.fuin.utils4j.ToDebugStringCapable;
import org.fuin.utils4j.Utils4J;

public final class SrcFile
extends AbstractFile
implements ToDebugStringCapable {
    public static final String UNZIP_TOKEN = "UNZIP";
    private final long size;
    private final boolean unzip;
    private final boolean loadAlways;
    private final boolean addToClasspath;
    private final String srcFileUrl;
    private final int order;

    public SrcFile(File baseDir, File file, boolean unzip, boolean loadAlways, boolean addToClasspath, String srcFileUrl) {
        super(baseDir, file);
        this.size = file.length();
        this.unzip = unzip;
        this.loadAlways = loadAlways;
        this.addToClasspath = addToClasspath;
        Utils4J.checkNotNull((String)"srcFileUrl", (Object)srcFileUrl);
        this.srcFileUrl = srcFileUrl;
        this.order = 0;
    }

    public SrcFile(String path, String filename, String md5Hash, long size, boolean unzip, boolean loadAlways, boolean addToClasspath, String srcFileUrl, int order) {
        super(path, filename, md5Hash);
        this.size = size;
        this.unzip = unzip;
        this.loadAlways = loadAlways;
        this.addToClasspath = addToClasspath;
        Utils4J.checkNotNull((String)"srcFileUrl", (Object)srcFileUrl);
        this.srcFileUrl = srcFileUrl;
        this.order = order;
    }

    public SrcFile(SrcFile srcFile, File file) {
        this(srcFile.getPath(), srcFile.getFilename(), Utils4J.createHashMD5((File)file), file.length(), srcFile.isUnzip(), srcFile.isLoadAlways(), srcFile.isAddToClasspath(), srcFile.getSrcFileUrl(), srcFile.getOrder());
    }

    public final long getSize() {
        return this.size;
    }

    public final int getSizeAsInt() {
        if (this.size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.size;
    }

    public final boolean isUnzip() {
        return this.unzip;
    }

    public final boolean isAddToClasspath() {
        return this.addToClasspath;
    }

    public final boolean isLoadAlways() {
        return this.loadAlways;
    }

    public final String getSrcFileUrl() {
        return this.srcFileUrl;
    }

    public final URL getSrcFileURL() {
        if (this.srcFileUrl == null) {
            return null;
        }
        try {
            return new URL(this.srcFileUrl);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final int getOrder() {
        return this.order;
    }

    public final String toXML() {
        String orderStr = this.order == 0 ? "" : " order=\"" + this.order + "\"";
        return "<file path=\"" + this.getSlashPath() + "\" file=\"" + this.getFilename() + "\" hash=\"" + this.getMd5Hash() + "\" size=\"" + this.size + "\" unzip=\"" + this.unzip + "\" loadAlways=\"" + this.loadAlways + "\" addToClasspath=\"" + this.addToClasspath + "\" srcFileUrl=\"" + this.srcFileUrl + "\"" + orderStr + "/>";
    }

    public final String toString() {
        return this.getRelativeSlashPathAndFilename();
    }

    public final String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("path=" + this.getPath() + ", ");
        sb.append("file=" + this.getFilename() + ", ");
        sb.append("hash=" + this.getMd5Hash() + ", ");
        sb.append("size=" + this.size + ", ");
        sb.append("unzip=" + this.unzip + ", ");
        sb.append("loadAlways=" + this.loadAlways + ", ");
        sb.append("addToClasspath=" + this.addToClasspath + ", ");
        sb.append("srcFileUrl=" + this.srcFileUrl + ", ");
        sb.append("order=" + this.order);
        return sb.toString();
    }
}

