/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.IOException;
import org.fuin.utils4j.ToDebugStringCapable;
import org.fuin.utils4j.Utils4J;

public final class MkDir
implements ToDebugStringCapable {
    private final String path;

    public MkDir(File baseDir, File dir) {
        this(Utils4J.getRelativePath((File)baseDir, (File)dir).replace(File.separatorChar, '/'));
    }

    public MkDir(String path) {
        this.path = path == null ? "" : path.replace('/', File.separatorChar);
    }

    public final String getPath() {
        return this.path;
    }

    public final String getCanonicalPath(File baseDir) {
        try {
            File dir = new File(baseDir, this.path);
            return dir.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final File getDestDir(File baseDir) {
        String name = this.getCanonicalPath(baseDir);
        return new File(name);
    }

    public final String getSlashPath() {
        return this.path.replace(File.separatorChar, '/');
    }

    public final String toXML() {
        return "<mkdir path=\"" + this.getSlashPath() + "\"" + "/>";
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MkDir other = (MkDir)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public final String toDebugString() {
        return this.path;
    }

    public final String toString() {
        return this.getSlashPath();
    }
}

