/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayOutputStream;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.exec.ExecuteException;
import org.fuin.kickstart4j.ErrorPanel;
import org.fuin.kickstart4j.MessagesWrapper;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.common.FramePositioner;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;

public final class ErrorDialog
implements Runnable {
    private final String message;
    private final int exitCode;

    private ErrorDialog(ByteArrayOutputStream errStream, ExecuteException executeException, int exitCode) {
        Utils4J.checkNotNull((String)"errStream", (Object)errStream);
        Utils4J.checkNotNull((String)"executeException", (Object)executeException);
        String msg = errStream.toString();
        this.message = msg.length() == 0 ? executeException.getMessage() : msg;
        this.exitCode = exitCode;
    }

    private ErrorDialog(String message, int exitCode) {
        Utils4J.checkNotNull((String)"message", (Object)message);
        this.message = message;
        this.exitCode = exitCode;
    }

    public void run() {
        ErrorPanel panel = new ErrorPanel();
        panel.setMessage(this.message);
        panel.setPreferredSize(new Dimension(600, 400));
        panel.setCloseListener(new ErrorPanel.CloseListener(){

            public void onClose(ErrorPanel panel) {
                System.exit(ErrorDialog.this.exitCode);
            }
        });
        JFrame frame = Utils4Swing.createShowAndPosition((String)new MessagesWrapper(Locale.getDefault()).getErrorMessageDialogTitle(), (Container)panel, (boolean)false, (FramePositioner)new ScreenCenterPositioner());
        frame.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                System.exit(ErrorDialog.this.exitCode);
            }
        });
    }

    public static void showAndExit(ByteArrayOutputStream errStream, ExecuteException executeException, int exitCode) {
        SwingUtilities.invokeLater(new ErrorDialog(errStream, executeException, exitCode));
    }

    public static void showAndExit(String message, int exitCode) {
        SwingUtilities.invokeLater(new ErrorDialog(message, exitCode));
    }
}

