/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.fuin.kickstart4j.Config;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.MkDir;
import org.fuin.kickstart4j.SrcDir;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.utils4j.Utils4J;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ConfigParser {
    private final ConfigHandler handler = new ConfigHandler();

    public void parse(URL url) throws InvalidConfigException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.newSAXParser().parse(url.toExternalForm(), (DefaultHandler)this.handler);
        }
        catch (SAXException e) {
            throw new InvalidConfigException(url, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidConfigException(url, (Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidConfigException(url, (Throwable)e);
        }
    }

    public void copyToConfig(Config config) throws InvalidConfigException {
        List elements = this.handler.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            String path;
            Map atts;
            ConfigElement element = (ConfigElement)elements.get(i);
            if (element.getName().equals("file")) {
                atts = element.getAttributes();
                path = (String)atts.get("path");
                ConfigParser.checkNotNull(element, "path", path);
                String file = (String)atts.get("file");
                ConfigParser.checkNotNull(element, "file", file);
                String hash = (String)atts.get("hash");
                ConfigParser.checkNotNull(element, "hash", hash);
                String size = (String)atts.get("size");
                ConfigParser.checkNotNull(element, "size", size);
                boolean unzip = ConfigParser.getBoolean(atts, "unzip", false);
                boolean loadAlways = ConfigParser.getBoolean(atts, "loadAlways", false);
                boolean addToClasspath = ConfigParser.getBoolean(atts, "addToClasspath", false);
                String srcFileUrl = (String)atts.get("srcFileUrl");
                ConfigParser.checkNotNull(element, "srcFileUrl", srcFileUrl);
                int order = ConfigParser.getInteger(atts, "order", 0);
                config.getSrcFiles().add(new SrcFile(path, file, hash, Long.valueOf(size), unzip, loadAlways, addToClasspath, srcFileUrl, order));
                continue;
            }
            if (element.getName().equals("mkdir")) {
                atts = element.getAttributes();
                path = (String)atts.get("path");
                ConfigParser.checkNotNull(element, "path", path);
                config.getMkDirs().add(new MkDir(path));
                continue;
            }
            if (element.getName().equals("dir")) {
                atts = element.getAttributes();
                path = (String)atts.get("path");
                ConfigParser.checkNotNull(element, "path", path);
                String srcPathUrl = (String)atts.get("srcPathUrl");
                ConfigParser.checkNotNull(element, "srcPathUrl", srcPathUrl);
                config.getSrcDirs().add(new SrcDir(path, srcPathUrl));
                continue;
            }
            this.put(config, element.getName(), element.getText());
        }
    }

    public final void put(Config config, String key, String value) {
        if (key.equals("title")) {
            config.setTitle(value);
        } else if (key.equals("vendor")) {
            config.setVendor(value);
        } else if (key.equals("description")) {
            config.setDescription(value);
        } else if (key.equals("exitAfterExecute")) {
            config.setExitAfterExecute(this.toBoolean(value));
        } else if (key.equals("destPath")) {
            config.setDestPath(value);
        } else if (key.equals("idFilename")) {
            config.setIdFilename(value);
        } else if (key.equals("silentInstall")) {
            config.setSilentInstall(this.toBoolean(value));
        } else if (key.equals("silentUpdate")) {
            config.setSilentUpdate(this.toBoolean(value));
        } else if (key.equals("locale")) {
            config.setLocale(value);
        } else if (key.equals("lazyLoading")) {
            config.setLazyLoading(this.toBoolean(value));
        } else if (key.equals("showStartFrame")) {
            config.setShowStartFrame(this.toBoolean(value));
        } else if (key.equals("startFrameDelaySeconds")) {
            config.setStartFrameDelaySeconds(this.toInt(value));
        } else if (key.equals("javaExe")) {
            config.setJavaExe(value);
        } else if (key.equals("javaArgs")) {
            config.setJavaArgs(value);
        } else if (key.equals("version")) {
            config.setVersion(value);
        } else if (key.equals("msgFileUrl")) {
            config.setMsgFileUrl(value);
        } else if (key.equals("logFilename")) {
            config.setLogFilename(value);
        }
    }

    private boolean toBoolean(String str) {
        if (str == null) {
            return false;
        }
        String trimmed = str.trim();
        if (trimmed.length() == 0) {
            return false;
        }
        return Boolean.valueOf(trimmed);
    }

    private int toInt(String str) {
        if (str == null) {
            return 0;
        }
        String trimmed = str.trim();
        if (trimmed.length() == 0) {
            return 0;
        }
        return Integer.valueOf(trimmed);
    }

    private static void checkNotNull(ConfigElement element, String attrName, String attrValue) throws InvalidConfigException {
        if (attrValue == null) {
            throw new InvalidConfigException("Element '" + element.getName() + "' missing required attribute '" + attrName + "'!");
        }
    }

    private static boolean getBoolean(Map atts, String key, boolean defaultValue) {
        String value = (String)atts.get(key);
        if (value == null) {
            return defaultValue;
        }
        String str = value.trim();
        if (str.length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(str);
    }

    private static int getInteger(Map atts, String key, int defaultValue) {
        String value = (String)atts.get(key);
        if (value == null) {
            return defaultValue;
        }
        String str = value.trim();
        if (str.length() == 0) {
            return defaultValue;
        }
        return Integer.valueOf(str);
    }

    public static void parse(Config config, File configFile) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"config", (Object)config);
        Utils4J.checkNotNull((String)"configFile", (Object)configFile);
        Utils4J.checkValidFile((File)configFile);
        try {
            ConfigParser.parse(config, configFile.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Error creating file URL '" + configFile + "'!", ex);
        }
    }

    public static void parse(Config config, URL configFileURL) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"config", (Object)config);
        Utils4J.checkNotNull((String)"configFileURL", (Object)configFileURL);
        ConfigParser parser = new ConfigParser();
        parser.parse(configFileURL);
        parser.copyToConfig(config);
    }

    public static Config create(URL configFileURL) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"configFileURL", (Object)configFileURL);
        Config config = new Config();
        ConfigParser.parse(config, configFileURL);
        return config;
    }

    public static Config create(File configFile) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"configFile", (Object)configFile);
        Utils4J.checkValidFile((File)configFile);
        try {
            return ConfigParser.create(configFile.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Error creating file URL '" + configFile + "'!", ex);
        }
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private final List elements = new ArrayList();
        private ConfigElement element = null;
        private int level = 0;

        private ConfigHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.level == 1) {
                this.element = new ConfigElement(qName, atts);
                this.elements.add(this.element);
            }
            ++this.level;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.level == 2 && this.element != null) {
                this.element.setText(String.copyValueOf(ch, start, length));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.level == 1) {
                this.element = null;
            }
            --this.level;
        }

        public List getElements() {
            return this.elements;
        }
    }

    private static final class ConfigElement {
        private final String name;
        private final Map attributes;
        private String text = null;

        public ConfigElement(String name, Attributes atts) {
            this.name = name;
            this.attributes = new HashMap();
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                this.attributes.put(atts.getQName(i), atts.getValue(i));
            }
        }

        public final Map getAttributes() {
            return this.attributes;
        }

        public final String getName() {
            return this.name;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            if (text == null) {
                this.text = null;
            } else {
                this.text = text.trim();
                if (this.text.length() == 0) {
                    this.text = null;
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name);
            sb.append("=");
            sb.append(this.text);
            sb.append(" {");
            int count = 0;
            Iterator it = this.attributes.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)this.attributes.get(key);
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(key);
                sb.append("=");
                sb.append(value);
                ++count;
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

