/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import org.fuin.kickstart4j.MessagesWrapper;
import org.fuin.utils4j.Utils4J;

public final class CmdLineOption {
    private final String key;
    private final String valueName;
    private final boolean required;
    private final String usage;

    public CmdLineOption(String key, String valueName, String usage) {
        this(key, valueName, usage, false);
    }

    public CmdLineOption(String key, String valueName, String usage, boolean required) {
        Utils4J.checkNotNull((String)"key", (Object)key);
        Utils4J.checkNotNull((String)"valueName", (Object)valueName);
        Utils4J.checkNotNull((String)"usage", (Object)usage);
        this.key = key;
        this.valueName = valueName;
        this.usage = usage;
        this.required = required;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getUsage() {
        return this.usage;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final String getValueName() {
        return this.valueName;
    }

    public final String getOptionText(MessagesWrapper msg) {
        String requiredStr = this.required ? " [" + msg.getOptionRequired() + "]" : "";
        return "-" + this.key + " " + this.valueName + "  " + this.usage + requiredStr;
    }
}

