/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.fuin.utils4j.Cancelable;
import org.fuin.utils4j.CancelableVolatile;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.common.Utils4Swing;
import org.fuin.utils4swing.progress.FileCopyProgressInputStream;
import org.fuin.utils4swing.progress.FileCopyProgressListener;
import org.fuin.utils4swing.progress.FileCopyProgressMonitor;

public final class Utils {
    private static final Logger LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.fuin.kickstart4j.Utils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    private Utils() {
        throw new UnsupportedOperationException("Creating instances is not allowed!");
    }

    public static void copyURLToFile(FileCopyProgressListener listener, URL srcFileUrl, File destFile, int fileNo, int fileSize) throws FileNotFoundException {
        if (listener != null) {
            listener.updateFile(srcFileUrl.toString(), destFile.toString(), fileNo, fileSize);
        }
        try {
            FileCopyProgressInputStream input = new FileCopyProgressInputStream(listener, srcFileUrl.openStream(), fileSize);
            try {
                FileOutputStream output = FileUtils.openOutputStream((File)destFile);
                try {
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void unzip(final FileCopyProgressListener listener, final File zipFile, final int zipFileNo, File destDir, Cancelable cancelable) {
        try {
            Utils4J.unzip((File)zipFile, (File)destDir, (Utils4J.UnzipInputStreamWrapper)new Utils4J.UnzipInputStreamWrapper(){

                public InputStream wrapInputStream(InputStream in, ZipEntry entry, File destFile) {
                    if (entry.getSize() > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Cannot handle files larger than 2147483647 bytes!");
                    }
                    if (listener != null) {
                        listener.updateFile(zipFile.toString(), destFile.toString(), zipFileNo, (int)entry.getSize());
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("UNZIP " + zipFile + " => " + destFile));
                    }
                    return new FileCopyProgressInputStream(listener, in, (int)entry.getSize());
                }
            }, (Cancelable)cancelable);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void copyURLToFile(String url, File file) {
        try {
            FileUtils.copyURLToFile((URL)new URL(url), (File)file);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error copying URL to file!", ex);
        }
    }

    public static void main(String[] args) {
        Utils4Swing.initSystemLookAndFeel();
        CancelableVolatile cancelable = new CancelableVolatile();
        ArrayList<File> zipFiles = new ArrayList<File>();
        zipFiles.add(new File("C:\\test.zip"));
        FileCopyProgressMonitor monitor = new FileCopyProgressMonitor((Cancelable)cancelable, "Unzip Test", zipFiles.size());
        monitor.open();
        try {
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < zipFiles.size()) {
                if (cancelable.isCanceled()) break;
                Utils.unzip((FileCopyProgressListener)monitor, (File)zipFiles.get(i), i + 1, new File("C:\\temp"), (Cancelable)cancelable);
                ++i;
            }
            System.out.println(System.currentTimeMillis() - start);
        }
        finally {
            monitor.close();
        }
    }
}

