/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.utils4j.Utils4J;

public final class UpdateSet {
    private final File destDir;
    private final List newFiles = new ArrayList();
    private final List changedFiles = new ArrayList();
    private final List deletedFiles = new ArrayList();
    private final List unchangedFiles = new ArrayList();
    private final List decompressFiles = new ArrayList();
    private final List classpathJarFiles = new ArrayList();
    private final List mkDirs = new ArrayList();

    public UpdateSet(List srcFiles, List mkDirs, File destDir, boolean lazyLoading) {
        Utils4J.checkNotNull((String)"srcFiles", (Object)srcFiles);
        Utils4J.checkNotNull((String)"mkDirs", (Object)mkDirs);
        Utils4J.checkNotNull((String)"destDir", (Object)destDir);
        Utils4J.checkValidDir((File)destDir);
        this.destDir = destDir;
        this.mkDirs.addAll(mkDirs);
        int i = 0;
        while (i < srcFiles.size()) {
            SrcFile srcFile = (SrcFile)srcFiles.get(i);
            if (!lazyLoading || lazyLoading && (srcFile.isLoadAlways() || srcFile.isAddToClasspath())) {
                File dir = new File(destDir, srcFile.getPath());
                File dest = new File(dir, srcFile.getFilename());
                if (dest.exists()) {
                    this.handleExistingFile(srcFile, dest);
                } else {
                    this.handleNewFile(srcFile);
                }
                if (srcFile.isAddToClasspath()) {
                    this.classpathJarFiles.add(srcFile);
                }
            }
            ++i;
        }
    }

    private void handleNewFile(SrcFile srcFile) {
        this.newFiles.add(srcFile);
        if (srcFile.isUnzip()) {
            this.decompressFiles.add(srcFile);
        }
    }

    private void handleExistingFile(SrcFile srcFile, File dest) {
        String destHash = Utils4J.createHashMD5((File)dest);
        if (srcFile.getMd5Hash().equals(destHash)) {
            this.unchangedFiles.add(srcFile);
        } else {
            this.changedFiles.add(srcFile);
            if (srcFile.isUnzip()) {
                this.decompressFiles.add(srcFile);
            }
        }
    }

    public final File getDestDir() {
        return this.destDir;
    }

    public final List getNewFiles() {
        return this.newFiles;
    }

    public final List getChangedFiles() {
        return this.changedFiles;
    }

    public final List getDeletedFiles() {
        return this.deletedFiles;
    }

    public final List getUnchangedFiles() {
        return this.unchangedFiles;
    }

    public final List getDecompressFiles() {
        return this.decompressFiles;
    }

    public final List getClasspathJarFiles() {
        return this.classpathJarFiles;
    }

    public final List getMkDirs() {
        return this.mkDirs;
    }

    public final boolean isUpdateNecessary() {
        return this.newFiles.size() + this.changedFiles.size() + this.deletedFiles.size() > 0;
    }

    public final String createClasspath() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.classpathJarFiles.size()) {
            SrcFile srcFile = (SrcFile)this.classpathJarFiles.get(i);
            if (i > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append("\"");
            sb.append(srcFile.getRelativeSlashPathAndFilename());
            sb.append("\"");
            ++i;
        }
        return sb.toString();
    }
}

