/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.fuin.kickstart4j.Config;
import org.fuin.kickstart4j.ConfigParser;
import org.fuin.kickstart4j.DeleteException;
import org.fuin.kickstart4j.FileLoader;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.LoadingFileException;
import org.fuin.kickstart4j.SrcDir;
import org.fuin.kickstart4j.SrcDirNotFoundException;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.kickstart4j.SrcFileNotFoundException;
import org.fuin.kickstart4j.Utils;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.progress.FileCopyProgressListener;

public final class SrcFileLoader
implements FileLoader {
    private static final Logger LOG;
    private final Config config;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.fuin.kickstart4j.SrcFileLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public SrcFileLoader() throws InvalidConfigException {
        try {
            File configFile = new File("application.xml").getCanonicalFile();
            Utils4J.checkValidFile((File)configFile);
            this.config = ConfigParser.create(configFile);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot get canonical file!", ex);
        }
    }

    public SrcFileLoader(String configPathAndFilename) throws InvalidConfigException {
        try {
            File configFile = new File(configPathAndFilename).getCanonicalFile();
            Utils4J.checkValidFile((File)configFile);
            this.config = ConfigParser.create(configFile);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot get canonical file!", ex);
        }
    }

    public SrcFileLoader(URL configFileURL) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"configFileURL", (Object)configFileURL);
        this.config = ConfigParser.create(configFileURL);
    }

    public SrcFileLoader(Config config) {
        Utils4J.checkNotNull((String)"config", (Object)config);
        this.config = config;
    }

    public final Config getConfig() {
        return this.config;
    }

    private File loadHashedFile(String path, String filename, FileCopyProgressListener listener) throws SrcFileNotFoundException, FileNotFoundException {
        SrcFile srcFile = this.config.findSrcFile(path, filename);
        URL srcFileUrl = srcFile.getSrcFileURL();
        File destFile = srcFile.getDestFile(this.config.getDestDir());
        if (destFile.exists()) {
            String destHash = Utils4J.createHashMD5((File)destFile);
            if (!srcFile.getMd5Hash().equals(destHash)) {
                Utils.copyURLToFile(listener, srcFileUrl, destFile, 1, srcFile.getSizeAsInt());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("CHANGED: " + srcFileUrl + " => " + destFile));
                }
            }
        } else {
            Utils.copyURLToFile(listener, srcFileUrl, destFile, 1, srcFile.getSizeAsInt());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("NEW: " + srcFileUrl + " => " + destFile));
            }
        }
        return destFile;
    }

    private File loadByDirectory(String path, String filename, FileCopyProgressListener listener) throws SrcDirNotFoundException, FileNotFoundException {
        SrcDir srcDir = this.config.findSrcDir(path);
        URL srcFileUrl = srcDir.getSrcFileURL(filename);
        File destFile = srcDir.getDestFile(this.config.getDestDir(), filename);
        Utils.copyURLToFile(listener, srcFileUrl, destFile, 1, 0);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("COPY: " + srcFileUrl + " => " + destFile));
        }
        return destFile;
    }

    public File loadFile(String path, String filename) throws LoadingFileException {
        return this.loadFile(path, filename, null);
    }

    public File loadFile(String path, String filename, FileCopyProgressListener listener) throws LoadingFileException {
        Utils4J.checkNotNull((String)"path", (Object)path);
        Utils4J.checkNotNull((String)"filename", (Object)filename);
        try {
            try {
                return this.loadHashedFile(path, filename, listener);
            }
            catch (SrcFileNotFoundException ex) {
                return this.loadByDirectory(path, filename, listener);
            }
        }
        catch (FileNotFoundException ex) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("NOT FOUND: " + ex.getMessage()));
            }
            throw new LoadingFileException("Source file not found! [path='" + path + "', filename='" + filename + "']", ex);
        }
        catch (SrcDirNotFoundException ex) {
            throw new LoadingFileException("Unknown file! [path='" + path + "', filename='" + filename + "']", ex);
        }
        catch (RuntimeException ex) {
            throw new LoadingFileException("Load error! [path='" + path + "', filename='" + filename + "']", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void deleteFile(String path, String filename) throws DeleteException {
        Utils4J.checkNotNull((String)"path", (Object)path);
        Utils4J.checkNotNull((String)"filename", (Object)filename);
        String trimmedFilename = filename.trim();
        Utils4J.checkNotEmpty((String)"filename", (String)trimmedFilename);
        String trimmedPath = path.trim();
        try {
            File dir = trimmedPath.length() == 0 ? this.config.getDestDir() : new File(this.config.getDestDir(), trimmedPath);
            File file = new File(dir, trimmedFilename);
            if (file.exists()) {
                if (!file.delete()) throw new DeleteException("Cannot delete file '" + file + "'!");
                LOG.info((Object)("DELETED " + file));
                return;
            } else {
                LOG.info((Object)("DELETE (does not exist) " + file));
            }
            return;
        }
        catch (RuntimeException ex) {
            throw new DeleteException("Unexpected delete error! [path='" + path + "', filename='" + filename + "']", ex);
        }
    }

    public final void deletePath(String path) throws DeleteException {
        block5: {
            Utils4J.checkNotNull((String)"path", (Object)path);
            String trimmedPath = path.trim();
            Utils4J.checkNotEmpty((String)"path", (String)trimmedPath);
            try {
                File dir = new File(this.config.getDestDir(), trimmedPath);
                if (dir.exists()) {
                    try {
                        FileUtils.deleteDirectory((File)dir);
                        LOG.info((Object)("DELETED " + dir));
                        break block5;
                    }
                    catch (IOException e) {
                        throw new DeleteException("Cannot delete directory '" + dir + "'!");
                    }
                }
                LOG.info((Object)("DELETE (does not exist) " + dir));
            }
            catch (RuntimeException ex) {
                throw new DeleteException("Unexpected delete error! [path='" + path + "']", ex);
            }
        }
    }
}

