/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.MessagesWrapper;
import org.fuin.kickstart4j.MkDir;
import org.fuin.kickstart4j.SrcDir;
import org.fuin.kickstart4j.SrcDirNotFoundException;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.kickstart4j.SrcFileNotFoundException;
import org.fuin.utils4j.Utils4J;

public final class Config {
    private String lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
    private String idFilename;
    private boolean exitAfterExecute = true;
    private String destPath = null;
    private boolean silentInstall = false;
    private boolean silentUpdate = false;
    private boolean firstInstallation = true;
    private Locale locale = Locale.getDefault();
    private String msgFileUrl = null;
    private MessagesWrapper messages = null;
    private boolean lazyLoading = false;
    private Map cmdLineOptions = new HashMap();
    private String javaExe = null;
    private String javaArgs = null;
    private String title = null;
    private String vendor = null;
    private String description = null;
    private List srcFiles = new ArrayList();
    private List mkDirs = new ArrayList();
    private List srcDirs = new ArrayList();
    private String configFileUrl = null;
    private String version = null;
    private String xmlEncoding = "ISO-8859-1";
    private String logFilename = String.valueOf(System.getProperty("user.home")) + File.separator + "kickstart4j.log";

    public final String getLookAndFeelClassName() {
        return this.lookAndFeelClassName;
    }

    public final void setLookAndFeelClassName(String lnfClassName) {
        this.lookAndFeelClassName = lnfClassName == null ? UIManager.getSystemLookAndFeelClassName() : lnfClassName;
    }

    public final boolean isExitAfterExecute() {
        return this.exitAfterExecute;
    }

    public final void setExitAfterExecute(boolean exitAfterExecute) {
        this.exitAfterExecute = exitAfterExecute;
    }

    public final File getDestDir() {
        return new File(this.getDestPath());
    }

    public final String getDestPath() {
        return Utils4J.replaceVars((String)this.destPath, (Map)this.cmdLineOptions);
    }

    public final void setDestPath(String destPath) {
        if (destPath == null) {
            throw new IllegalArgumentException("The argument 'destPath' cannot be null!");
        }
        this.destPath = destPath;
    }

    public final String getIdFilename() {
        return Utils4J.replaceVars((String)this.idFilename, (Map)this.cmdLineOptions);
    }

    public final void setIdFilename(String id) {
        if (id == null) {
            throw new IllegalArgumentException("The argument 'id' cannot be null!");
        }
        this.idFilename = id;
    }

    public final boolean isSilentInstall() {
        return this.silentInstall;
    }

    public final void setSilentInstall(boolean silentInstall) {
        this.silentInstall = silentInstall;
    }

    public final boolean isSilentUpdate() {
        return this.silentUpdate;
    }

    public final void setSilentUpdate(boolean silentUpdate) {
        this.silentUpdate = silentUpdate;
    }

    public final boolean isFirstInstallation() {
        return this.firstInstallation;
    }

    public final void setFirstInstallation(boolean firstInstallation) {
        this.firstInstallation = firstInstallation;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    public final void setLocale(String locale) {
        if (locale == null) {
            this.locale = Locale.getDefault();
        } else {
            String variant;
            String country;
            String language;
            StringTokenizer tok = new StringTokenizer(locale, ",");
            int count = tok.countTokens();
            if (count == 1) {
                language = tok.nextToken();
                country = "";
                variant = "";
            } else if (count == 2) {
                language = tok.nextToken();
                country = tok.nextToken();
                variant = "";
            } else if (count == 3) {
                language = tok.nextToken();
                country = tok.nextToken();
                variant = tok.nextToken();
            } else {
                throw new IllegalArgumentException("The argument '" + locale + "' is not valid!");
            }
            this.locale = new Locale(language, country, variant);
        }
    }

    public final String getMsgFileUrl() {
        return this.msgFileUrl;
    }

    public final URL getMsgFileURL() {
        if (this.msgFileUrl == null) {
            return null;
        }
        try {
            return new URL(this.msgFileUrl);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void setMsgFileUrl(String msgFileUrl) {
        this.msgFileUrl = msgFileUrl == null ? null : msgFileUrl.trim();
    }

    public final void check() throws InvalidConfigException {
        if (this.destPath == null) {
            throw new InvalidConfigException("The 'destPath' is null!");
        }
        if (this.idFilename == null) {
            throw new InvalidConfigException("The 'idFilename' is null!");
        }
        if (this.lazyLoading && (this.configFileUrl == null || this.configFileUrl.trim().length() == 0)) {
            throw new InvalidConfigException("The 'configFileUrl' is null or empty!");
        }
    }

    public final MessagesWrapper getMessages() {
        if (this.messages == null) {
            try {
                this.messages = new MessagesWrapper(Utils4J.loadProperties((URL)this.getMsgFileURL()));
            }
            catch (RuntimeException ex) {
                this.messages = new MessagesWrapper(this.locale);
            }
        }
        return this.messages;
    }

    public final boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public final void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    public final Map getCmdLineOptions() {
        return this.cmdLineOptions;
    }

    public final String getJavaArgs() {
        return Utils4J.replaceVars((String)this.javaArgs, (Map)this.cmdLineOptions);
    }

    public final void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    public final String getJavaExe() {
        return Utils4J.replaceVars((String)this.javaExe, (Map)this.cmdLineOptions);
    }

    public final void setJavaExe(String javaExe) {
        this.javaExe = javaExe;
    }

    public final String getDescription() {
        return Utils4J.replaceVars((String)this.description, (Map)this.cmdLineOptions);
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getTitle() {
        return Utils4J.replaceVars((String)this.title, (Map)this.cmdLineOptions);
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public final String getVendor() {
        return Utils4J.replaceVars((String)this.vendor, (Map)this.cmdLineOptions);
    }

    public final void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public final List getSrcFiles() {
        return this.srcFiles;
    }

    public final List getMkDirs() {
        return this.mkDirs;
    }

    public final List getSrcDirs() {
        return this.srcDirs;
    }

    public final String getConfigFileUrl() {
        return Utils4J.replaceVars((String)this.configFileUrl, (Map)this.cmdLineOptions);
    }

    public final URL getConfigFileURL() {
        if (this.configFileUrl == null) {
            return null;
        }
        try {
            return new URL(Utils4J.replaceVars((String)this.configFileUrl, (Map)this.cmdLineOptions));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Error creating URL from String '" + this.configFileUrl + "'!", ex);
        }
    }

    public final void setConfigFileUrl(String configFileUrl) {
        this.configFileUrl = configFileUrl;
    }

    public final String getVersion() {
        return Utils4J.replaceVars((String)this.version, (Map)this.cmdLineOptions);
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public final void setXmlEncoding(String encoding) {
        this.xmlEncoding = encoding;
    }

    public final String getLogFilename() {
        return Utils4J.replaceVars((String)this.logFilename, (Map)this.cmdLineOptions);
    }

    public final void setLogFilename(String logFilename) {
        this.logFilename = logFilename == null ? String.valueOf(System.getProperty("user.home")) + File.separator + "kickstart4j.log" : logFilename.trim();
    }

    public final SrcFile findSrcFile(String path, String filename) throws SrcFileNotFoundException {
        Utils4J.checkNotNull((String)"path", (Object)path);
        Utils4J.checkNotNull((String)"filename", (Object)filename);
        String systemPath = path.replace('/', File.separatorChar);
        int i = 0;
        while (i < this.srcFiles.size()) {
            SrcFile srcFile = (SrcFile)this.srcFiles.get(i);
            if (srcFile.getPath().equals(systemPath) && srcFile.getFilename().equals(filename)) {
                return srcFile;
            }
            ++i;
        }
        throw new SrcFileNotFoundException(path, filename);
    }

    public final SrcDir findSrcDir(String path) throws SrcDirNotFoundException {
        Utils4J.checkNotNull((String)"path", (Object)path);
        String systemPath = path.replace('/', File.separatorChar);
        int i = 0;
        while (i < this.srcDirs.size()) {
            SrcDir srcDir = (SrcDir)this.srcDirs.get(i);
            if (srcDir.getPath().equals(systemPath)) {
                return srcDir;
            }
            ++i;
        }
        throw new SrcDirNotFoundException(path);
    }

    public final void replace(SrcFile oldSrcFile, SrcFile newSrcFile) {
        int i = this.srcFiles.indexOf(oldSrcFile);
        if (i == -1) {
            throw new IllegalArgumentException("The source file '" + oldSrcFile + "' was not found!");
        }
        this.srcFiles.remove(i);
        this.srcFiles.add(i, newSrcFile);
    }

    private String getText(String value, String defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        return value;
    }

    private String getTag(String tag, String value, String defaultVal) {
        if (value == null && defaultVal == null) {
            return "<" + tag + "/>";
        }
        return "<" + tag + ">" + this.getText(value, defaultVal) + "</" + tag + ">";
    }

    private String getTag(String tag, boolean value) {
        return "<" + tag + ">" + value + "</" + tag + ">";
    }

    private String getTag(String tag, Locale locale, Locale defaultLocale) {
        if (locale == null && defaultLocale == null) {
            return "<" + tag + "/>";
        }
        if (locale == null) {
            return "<" + tag + ">" + defaultLocale.getLanguage() + "</" + tag + ">";
        }
        return "<" + tag + ">" + locale.getLanguage() + "</" + tag + ">";
    }

    private String getTagLine(String tag, String value, String defaultVal) {
        return String.valueOf(this.getTag(tag, value, defaultVal)) + IOUtils.LINE_SEPARATOR;
    }

    private String getTagLine(String tag, boolean value) {
        return String.valueOf(this.getTag(tag, value)) + IOUtils.LINE_SEPARATOR;
    }

    private String getTagLine(String tag, Locale locale, Locale defaultLocale) {
        return String.valueOf(this.getTag(tag, locale, defaultLocale)) + IOUtils.LINE_SEPARATOR;
    }

    public final String toStaticXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\"?>" + IOUtils.LINE_SEPARATOR);
        sb.append("<application>" + IOUtils.LINE_SEPARATOR);
        sb.append("  " + this.getTagLine("version", this.getVersion(), null));
        sb.append("  " + this.getTagLine("title", this.getTitle(), null));
        sb.append("  " + this.getTagLine("vendor", this.getVendor(), null));
        sb.append("  " + this.getTagLine("description", this.getDescription(), null));
        sb.append("  " + this.getTagLine("exitAfterExecute", this.isExitAfterExecute()));
        sb.append("  " + this.getTagLine("destPath", this.getDestPath(), null));
        sb.append("  " + this.getTagLine("idFilename", this.getIdFilename(), ".yourapp"));
        sb.append("  " + this.getTagLine("silentInstall", this.isSilentInstall()));
        sb.append("  " + this.getTagLine("silentUpdate", this.isSilentUpdate()));
        sb.append("  " + this.getTagLine("locale", this.locale, Locale.getDefault()));
        sb.append("  " + this.getTagLine("lazyLoading", this.isLazyLoading()));
        sb.append("  " + this.getTagLine("logFilename", this.getLogFilename(), null));
        sb.append("  " + this.getTagLine("javaExe", this.getJavaExe(), null));
        sb.append("  " + this.getTagLine("javaArgs", this.getJavaArgs(), "-classpath ${classpath} com.company.product.MainClass"));
        sb.append("  " + this.getTagLine("msgFileUrl", this.msgFileUrl, null));
        int i = 0;
        while (i < this.mkDirs.size()) {
            MkDir mkDir = (MkDir)this.mkDirs.get(i);
            sb.append("  " + mkDir.toXML() + IOUtils.LINE_SEPARATOR);
            ++i;
        }
        i = 0;
        while (i < this.srcDirs.size()) {
            SrcDir srcDir = (SrcDir)this.srcDirs.get(i);
            sb.append("  " + srcDir.toXML() + IOUtils.LINE_SEPARATOR);
            ++i;
        }
        i = 0;
        while (i < this.srcFiles.size()) {
            SrcFile srcFile = (SrcFile)this.srcFiles.get(i);
            sb.append("  " + srcFile.toXML() + IOUtils.LINE_SEPARATOR);
            ++i;
        }
        sb.append("</application>" + IOUtils.LINE_SEPARATOR);
        return sb.toString();
    }

    public final String toVarXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\"?>" + IOUtils.LINE_SEPARATOR);
        sb.append("<application>" + IOUtils.LINE_SEPARATOR);
        sb.append("  " + this.getTagLine("version", this.version, null));
        sb.append("  " + this.getTagLine("title", this.title, "Your title"));
        sb.append("  " + this.getTagLine("vendor", this.vendor, null));
        sb.append("  " + this.getTagLine("description", this.description, null));
        sb.append("  " + this.getTagLine("exitAfterExecute", this.exitAfterExecute));
        sb.append("  " + this.getTagLine("destPath", this.destPath, "C:\\Program Files\\yourapp\\"));
        sb.append("  " + this.getTagLine("idFilename", this.idFilename, ".yourapp"));
        sb.append("  " + this.getTagLine("silentInstall", this.silentInstall));
        sb.append("  " + this.getTagLine("silentUpdate", this.silentUpdate));
        sb.append("  " + this.getTagLine("locale", this.locale, Locale.getDefault()));
        sb.append("  " + this.getTagLine("lazyLoading", this.lazyLoading));
        sb.append("  " + this.getTagLine("logFilename", this.logFilename, null));
        sb.append("  " + this.getTagLine("javaExe", this.javaExe, "jre/bin/java.exe"));
        sb.append("  " + this.getTagLine("javaArgs", this.javaArgs, "-classpath ${classpath} com.company.product.MainClass"));
        sb.append("  " + this.getTagLine("msgFileUrl", this.msgFileUrl, null));
        int i = 0;
        while (i < this.mkDirs.size()) {
            MkDir mkDir = (MkDir)this.mkDirs.get(i);
            sb.append("  " + mkDir.toXML() + IOUtils.LINE_SEPARATOR);
            ++i;
        }
        i = 0;
        while (i < this.srcDirs.size()) {
            SrcDir srcDir = (SrcDir)this.srcDirs.get(i);
            sb.append("  " + srcDir.toXML() + IOUtils.LINE_SEPARATOR);
            ++i;
        }
        i = 0;
        while (i < this.srcFiles.size()) {
            SrcFile srcFile = (SrcFile)this.srcFiles.get(i);
            sb.append("  " + srcFile.toXML() + IOUtils.LINE_SEPARATOR);
            ++i;
        }
        sb.append("</application>" + IOUtils.LINE_SEPARATOR);
        return sb.toString();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("configFileUrl=" + this.getConfigFileUrl() + ", ");
        sb.append("version=" + this.getVersion() + ", ");
        sb.append("title=" + this.getTitle() + ", ");
        sb.append("vendor=" + this.getVendor() + ", ");
        sb.append("description=" + this.getDescription() + ", ");
        sb.append("exitAfterExecute=" + this.isExitAfterExecute() + ", ");
        sb.append("destPath=" + this.getDestPath() + ", ");
        sb.append("idFilename=" + this.getIdFilename() + ", ");
        sb.append("silentInstall=" + this.isSilentInstall() + ", ");
        sb.append("silentUpdate=" + this.isSilentUpdate() + ", ");
        sb.append("locale=" + this.getLocale() + ", ");
        sb.append("lazyLoading=" + this.isLazyLoading() + ", ");
        sb.append("javaExe=" + this.getJavaExe() + ", ");
        sb.append("javaArgs=" + this.getJavaArgs() + ", ");
        sb.append("msgFileUrl=" + this.getMsgFileUrl() + ", ");
        sb.append("xmlEncoding=" + this.getXmlEncoding());
        sb.append("logFilename=" + this.getLogFilename());
        sb.append("srcFiles.size()=" + this.srcFiles.size());
        sb.append("srcDirs.size()=" + this.srcDirs.size());
        sb.append("mkDirs.size()=" + this.mkDirs.size());
        return sb.toString();
    }

    public final void writeToVarXML(File configFile, boolean backup) throws IOException {
        this.writeToXML(this.toVarXML(), configFile, backup);
    }

    public final void writeToStaticXML(File configFile, boolean backup) throws IOException {
        this.writeToXML(this.toStaticXML(), configFile, backup);
    }

    private final void writeToXML(String xml, File file, boolean backup) throws IOException {
        if (backup) {
            File bakFile = new File(file + ".bak");
            if (bakFile.exists()) {
                bakFile.delete();
            }
            file.renameTo(bakFile);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.write(xml);
        }
        finally {
            ((Writer)writer).close();
        }
    }
}

