/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.fuin.utils4j.Utils4J;

public final class MessagesWrapper {
    private static final String DEFAULT_MESSAGES = "messages";
    private final Properties props;

    MessagesWrapper(Locale locale) {
        ResourceBundle res = ResourceBundle.getBundle(Utils4J.getPackagePath(this.getClass()) + "/" + DEFAULT_MESSAGES, locale);
        Properties defaultProperties = new Properties();
        Enumeration<String> enu = res.getKeys();
        while (enu.hasMoreElements()) {
            String key = enu.nextElement();
            String value = res.getString(key);
            defaultProperties.put(key, value);
        }
        this.props = defaultProperties;
    }

    MessagesWrapper(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("The argument 'props' cannot be null!");
        }
        this.props = props;
    }

    public final String getUpdateAvailable() {
        return this.props.getProperty("update-available");
    }

    public final String getProgressMonitorTransferText() {
        return this.props.getProperty("progress-monitor-transfertext");
    }

    public final String getProgressMonitorSrcLabelText() {
        return this.props.getProperty("progress-monitor-srclabeltext");
    }

    public final String getProgressMonitorDestLabelText() {
        return this.props.getProperty("progress-monitor-destlabeltext");
    }

    public final String getProgressMonitorDecompressText() {
        return this.props.getProperty("progress-monitor-decompresstext");
    }

    public final String getSelectDestinationDirectory() {
        return this.props.getProperty("select-destination-directory");
    }

    public final String getOperationCanceled() {
        return this.props.getProperty("operation-canceled");
    }

    public final String getOptionUsageConfigFileUrl() {
        return this.props.getProperty("option-usage-configFileUrl");
    }

    public final String getOptionUsageLocale() {
        return this.props.getProperty("option-usage-locale");
    }

    public final String getOptionRequired() {
        return this.props.getProperty("option-required");
    }

    public final String getErrorMissingReuiredOptions() {
        return this.props.getProperty("error.missing-required-options");
    }

    public final String getErrorOptionWithoutPrefix(String arg) {
        return MessagesWrapper.replace(this.props.getProperty("error.option-without-prefix"), "$ARG", arg);
    }

    public final String getErrorValueMissingForOption(String arg) {
        return MessagesWrapper.replace(this.props.getProperty("error.value-missing-for-option"), "$ARG", arg);
    }

    private static final String replace(String str, String var, String val) {
        Utils4J.checkNotNull((String)"var", (Object)var);
        if (str == null || str.length() == 0) {
            return str;
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(var, val);
        return Utils4J.replaceVars((String)str, vars);
    }
}

