/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.launcher.CommandLauncher;
import org.apache.commons.exec.launcher.CommandLauncherFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.fuin.kickstart4j.CmdLineException;
import org.fuin.kickstart4j.CmdLineParser;
import org.fuin.kickstart4j.Config;
import org.fuin.kickstart4j.ConfigParser;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.MkDir;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.kickstart4j.UpdateSet;
import org.fuin.kickstart4j.Utils;
import org.fuin.utils4j.Cancelable;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.common.Utils4Swing;
import org.fuin.utils4swing.dialogs.CanceledException;
import org.fuin.utils4swing.dialogs.DirectorySelector;
import org.fuin.utils4swing.progress.FileCopyProgressListener;
import org.fuin.utils4swing.progress.FileCopyProgressMonitor;
import org.fuin.utils4swing.threadsafe.ThreadSafeJOptionPane;

public final class Kickstart4J {
    private static final Logger LOG = Logger.getLogger((Class)Kickstart4J.class);
    private static final String PROGRAM_TERMINATED_WITH_ERROR = "Program terminated with error!";
    private static final String INCOMPLETE_FILE = ".incomplete";
    private static final String PROGRAM_DIRECTORY_KEY = "program-directory";
    private final Config config;

    public Kickstart4J(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("The argument 'config' cannot be null!");
        }
        this.config = config;
    }

    private void initLogging() {
        try {
            File logFile = new File(this.config.getLogFilename()).getCanonicalFile();
            boolean ok = true;
            if (!logFile.getParentFile().exists()) {
                ok = logFile.getParentFile().mkdirs();
            }
            if (ok) {
                Properties props = new Properties();
                props.put("log4j.rootLogger", "INFO, FILE");
                props.put("log4j.appender.FILE", "org.apache.log4j.RollingFileAppender");
                props.put("log4j.appender.FILE.File", logFile.toString());
                props.put("log4j.appender.FILE.MaxFileSize", "1MB");
                props.put("log4j.appender.FILE.MaxBackupIndex", "1");
                props.put("log4j.appender.FILE.layout", "org.apache.log4j.PatternLayout");
                props.put("log4j.appender.FILE.layout.ConversionPattern", "%d [%t] %-5p %c - %m%n");
                PropertyConfigurator.configure((Properties)props);
            } else {
                LOG.error((Object)("Cannot create log directory: " + logFile.getParentFile()));
            }
        }
        catch (IOException ex) {
            LOG.error((Object)"Cannot create log!", (Throwable)ex);
        }
    }

    public final void execute() throws CanceledException, InvalidConfigException {
        Locale.setDefault(this.config.getLocale());
        File destDir = this.getDestDir();
        this.config.getCmdLineOptions().put("destDir", destDir.toString());
        this.config.check();
        this.initLogging();
        UpdateSet updateSet = new UpdateSet(this.config.getSrcFiles(), this.config.getMkDirs(), destDir, this.config.isLazyLoading());
        if (updateSet.isUpdateNecessary()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("An update is available: New=" + updateSet.getNewFiles().size() + ", Changed=" + updateSet.getChangedFiles().size() + ", Deleted=" + updateSet.getDeletedFiles().size() + ", SilentInstall=" + this.config.isSilentInstall() + ", SilentUpdate=" + this.config.isSilentUpdate() + ", FirstInstallation=" + this.config.isFirstInstallation()));
            }
            if (this.config.isSilentUpdate() || this.config.isFirstInstallation() || Kickstart4J.isAnswerYes(this.config.getMessages().getUpdateAvailable())) {
                this.execute(updateSet);
                File installationIncompleteFile = new File(destDir, INCOMPLETE_FILE);
                if (installationIncompleteFile.exists()) {
                    installationIncompleteFile.delete();
                }
            }
        } else {
            LOG.info((Object)"Files are up to date");
        }
        this.config.getCmdLineOptions().put("classpath", updateSet.createClasspath());
        this.saveConfigToTargetDir(destDir);
        CommandLine commandLine = new CommandLine(new File(this.config.getDestDir(), this.config.getJavaExe()));
        commandLine.addArguments(this.config.getJavaArgs(), false);
        this.logStart(destDir, commandLine.toString());
        this.startExternal(destDir, commandLine);
    }

    private void saveConfigToTargetDir(File destDir) {
        File appXmlFile = new File(destDir, "application.xml");
        try {
            String localConfigFileUrl = appXmlFile.toURI().toURL().toString();
            this.config.setConfigFileUrl(localConfigFileUrl);
            this.config.getCmdLineOptions().put("configFileUrl", localConfigFileUrl);
            this.config.writeToStaticXML(appXmlFile, true);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error writing " + appXmlFile + "!", ex);
        }
    }

    private File getIdFile(Config config) {
        return new File(Utils4J.getUserHomeDir(), config.getIdFilename());
    }

    private void execute(UpdateSet updateSet) throws CanceledException {
        this.executeMkdirs(updateSet);
        this.executeCopy(updateSet);
        this.executeDecompress(updateSet);
    }

    private void executeMkdirs(UpdateSet updateSet) {
        for (int i = 0; i < updateSet.getMkDirs().size(); ++i) {
            MkDir mkDir = (MkDir)updateSet.getMkDirs().get(i);
            File destDir = mkDir.getDestDir(updateSet.getDestDir());
            if (destDir.exists()) {
                LOG.info((Object)("MKDIR: " + destDir + " (Already exists)"));
                continue;
            }
            boolean ok = destDir.mkdirs();
            if (!LOG.isInfoEnabled()) continue;
            if (ok) {
                LOG.info((Object)("MKDIR: " + destDir));
                continue;
            }
            LOG.info((Object)("MKDIR FAILED: " + destDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCopy(UpdateSet updateSet) throws CanceledException {
        int max = updateSet.getNewFiles().size() + updateSet.getChangedFiles().size();
        if (max > 0) {
            Cancelable cancelable = new Cancelable(){
                private volatile boolean canceled = false;

                public void cancel() {
                    this.canceled = true;
                }

                public boolean isCanceled() {
                    return this.canceled;
                }
            };
            FileCopyProgressMonitor monitor = new FileCopyProgressMonitor(cancelable, this.config.getTitle(), this.config.getMessages().getProgressMonitorTransferText(), this.config.getMessages().getProgressMonitorSrcLabelText(), this.config.getMessages().getProgressMonitorDestLabelText(), max);
            int count = 0;
            monitor.open();
            try {
                if (cancelable.isCanceled()) {
                    throw new CanceledException();
                }
                count = this.copyFiles(updateSet, cancelable, (FileCopyProgressListener)monitor, updateSet.getNewFiles(), count, "NEW");
                if (cancelable.isCanceled()) {
                    throw new CanceledException();
                }
                count = this.copyFiles(updateSet, cancelable, (FileCopyProgressListener)monitor, updateSet.getChangedFiles(), count, "CHANGED");
                if (cancelable.isCanceled()) {
                    throw new CanceledException();
                }
                for (int i = 0; i < updateSet.getDeletedFiles().size(); ++i) {
                    if (cancelable.isCanceled()) {
                        break;
                    }
                    ++count;
                    String file = (String)updateSet.getDeletedFiles().get(i);
                    File destFile = new File(updateSet.getDestDir(), file);
                    boolean ok = destFile.delete();
                    if (LOG.isInfoEnabled()) {
                        if (ok) {
                            LOG.info((Object)("DELETED: " + destFile));
                        } else {
                            LOG.info((Object)("DELETE FAILED: " + destFile));
                        }
                    }
                    monitor.updateFile("", destFile.toString(), count, 0);
                }
            }
            finally {
                monitor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDecompress(UpdateSet updateSet) throws CanceledException {
        List compressedFiles = updateSet.getDecompressFiles();
        int max = compressedFiles.size();
        if (max > 0) {
            Cancelable cancelable = new Cancelable(){
                private volatile boolean canceled = false;

                public void cancel() {
                    this.canceled = true;
                }

                public boolean isCanceled() {
                    return this.canceled;
                }
            };
            FileCopyProgressMonitor monitor = new FileCopyProgressMonitor(cancelable, this.config.getTitle(), this.config.getMessages().getProgressMonitorDecompressText(), this.config.getMessages().getProgressMonitorSrcLabelText(), this.config.getMessages().getProgressMonitorDestLabelText(), max);
            monitor.open();
            try {
                for (int i = 0; i < max; ++i) {
                    SrcFile file = (SrcFile)compressedFiles.get(i);
                    File compressedFile = file.getDestFile(updateSet.getDestDir());
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Decompressing: " + compressedFile));
                    }
                    Utils.unzip((FileCopyProgressListener)monitor, compressedFile, i + 1, updateSet.getDestDir(), cancelable);
                }
            }
            finally {
                monitor.close();
            }
        }
    }

    private int copyFiles(UpdateSet updateSet, Cancelable cancelable, FileCopyProgressListener listener, List files, int total, String type) {
        int count = total;
        for (int i = 0; i < files.size() && !cancelable.isCanceled(); ++i) {
            ++count;
            SrcFile file = (SrcFile)files.get(i);
            URL srcFileUrl = file.getSrcFileURL();
            File destFile = file.getDestFile(updateSet.getDestDir());
            try {
                Utils.copyURLToFile(listener, srcFileUrl, destFile, count, file.getSizeAsInt());
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Source file not found!", ex);
            }
            String hash = Utils4J.createHash((File)destFile);
            if (!hash.equals(file.getMd5Hash())) {
                LOG.error((Object)("Hash local file (" + hash + ") is different from configuration hash (" + file.getMd5Hash() + ")! [" + srcFileUrl + "]"));
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)(type + ": " + srcFileUrl + " => " + destFile));
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStart(File dir, String commandLine) {
        try {
            File file = new File(dir, "start.log");
            FileWriter writer = new FileWriter(file);
            try {
                writer.write(commandLine);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void startExternal(File destDir, CommandLine commandLine) {
        CommandLauncher launcher = CommandLauncherFactory.createVMLauncher();
        try {
            launcher.exec(commandLine, null, destDir);
            if (this.config.isExitAfterExecute()) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private File getDestDir() throws CanceledException {
        File installationIncompleteFile;
        File dir;
        File idFile = this.getIdFile(this.config);
        if (idFile.exists()) {
            Properties props = Utils4J.loadProperties((File)idFile);
            String dirStr = props.getProperty(PROGRAM_DIRECTORY_KEY);
            if (dirStr == null) {
                throw new IllegalStateException("The property 'program-directory' was not found inside '" + idFile + "'!");
            }
            dir = new File(dirStr);
            Utils4J.checkValidDir((File)dir);
            installationIncompleteFile = new File(dir, INCOMPLETE_FILE);
        } else {
            Properties props = new Properties();
            String dirStr = this.config.isSilentInstall() ? this.config.getDestDir().toString() : DirectorySelector.selectDirectory((String)this.config.getMessages().getSelectDestinationDirectory(), (String)this.config.getDestDir().toString()).getDirectory();
            props.setProperty(PROGRAM_DIRECTORY_KEY, dirStr);
            Utils4J.saveProperties((File)idFile, (Properties)props, (String)"# --- DO NOT EDIT OR DELETE --- Generated by Kickstart4J ---");
            dir = new File(dirStr);
            installationIncompleteFile = new File(dir, INCOMPLETE_FILE);
            if (!dir.exists()) {
                try {
                    dir.mkdirs();
                    installationIncompleteFile.createNewFile();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Cannot create file '" + installationIncompleteFile + "'!");
                }
            }
        }
        this.config.setFirstInstallation(installationIncompleteFile.exists());
        return dir;
    }

    private static boolean isAnswerYes(String message) {
        int result = ThreadSafeJOptionPane.showConfirmDialog(null, (Object)message, (String)"TITLE", (int)0, (int)3);
        return result == 0;
    }

    private static void showError(String message) {
        ThreadSafeJOptionPane.showMessageDialog(null, (Object)message, (String)"Error", (int)0);
    }

    private static void showMessage(String message) {
        ThreadSafeJOptionPane.showMessageDialog(null, (Object)message, (String)"Hint", (int)1);
    }

    private static void displayCmdLineException(CmdLineParser parser, CmdLineException ex) {
        StringBuffer sb = new StringBuffer();
        sb.append(ex.getMessage());
        sb.append("\n");
        sb.append("\n");
        sb.append("java Kickstart4J [options]");
        sb.append("\n");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        parser.printUsage(out);
        sb.append(out.toString());
        sb.append("\n");
        System.out.println(sb);
        Kickstart4J.showError(sb.toString());
    }

    private static void displayException(Exception ex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(out));
        String msg = out.toString();
        System.err.println(msg);
        Kickstart4J.showError(msg);
    }

    public static void main(String[] args) {
        Logger log = Logger.getLogger((Class)Kickstart4J.class);
        Config config = new Config();
        try {
            CmdLineParser cmdLineParser = new CmdLineParser(Locale.getDefault());
            try {
                cmdLineParser.parse(args);
                if (log.isDebugEnabled()) {
                    log.info((Object)("Command line arguments: " + cmdLineParser));
                }
                cmdLineParser.copyToConfig(config);
                try {
                    ConfigParser.parse(config, config.getConfigFileURL());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Configuration: " + config));
                    }
                    Utils4Swing.initLookAndFeel((String)config.getLookAndFeelClassName());
                    new Kickstart4J(config).execute();
                    log.info((Object)"Operation finished successfully!");
                    System.exit(0);
                }
                catch (CanceledException ex) {
                    log.info((Object)"Operation canceled by user!");
                    Kickstart4J.showMessage(config.getMessages().getOperationCanceled());
                    System.exit(0);
                }
                catch (InvalidConfigException ex) {
                    log.error((Object)PROGRAM_TERMINATED_WITH_ERROR, (Throwable)ex);
                    Kickstart4J.displayException(ex);
                    System.exit(1);
                }
            }
            catch (CmdLineException ex) {
                log.error((Object)PROGRAM_TERMINATED_WITH_ERROR, (Throwable)ex);
                Kickstart4J.displayCmdLineException(cmdLineParser, ex);
                System.exit(1);
            }
        }
        catch (RuntimeException ex) {
            log.error((Object)PROGRAM_TERMINATED_WITH_ERROR, (Throwable)ex);
            Kickstart4J.displayException(ex);
            System.exit(1);
        }
    }
}

