/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.utils4j.Utils4J;

public final class UpdateSet {
    private final File destDir;
    private final List newFiles = new ArrayList();
    private final List changedFiles = new ArrayList();
    private final List deletedFiles = new ArrayList();
    private final List unchangedFiles = new ArrayList();
    private final List decompressFiles = new ArrayList();
    private final List classpathJarFiles = new ArrayList();

    public UpdateSet(List srcFiles, File destDir, boolean lazyLoading) {
        Utils4J.checkNotNull((String)"srcFiles", (Object)srcFiles);
        Utils4J.checkNotNull((String)"destDir", (Object)destDir);
        Utils4J.checkValidDir((File)destDir);
        this.destDir = destDir;
        for (int i = 0; i < srcFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)srcFiles.get(i);
            if (lazyLoading && (!lazyLoading || !srcFile.isLoadAlways() && !srcFile.isAddToClasspath())) continue;
            File dir = new File(destDir, srcFile.getPath());
            File dest = new File(dir, srcFile.getFilename());
            if (dest.exists()) {
                String destHash = Utils4J.createHash((File)dest);
                if (srcFile.getMd5Hash().equals(destHash)) {
                    this.unchangedFiles.add(srcFile);
                } else {
                    this.changedFiles.add(srcFile);
                    if (srcFile.isUnzip()) {
                        this.decompressFiles.add(srcFile);
                    }
                }
            } else {
                this.newFiles.add(srcFile);
                if (srcFile.isUnzip()) {
                    this.decompressFiles.add(srcFile);
                }
            }
            if (!srcFile.isAddToClasspath()) continue;
            this.classpathJarFiles.add(srcFile);
        }
    }

    public final File getDestDir() {
        return this.destDir;
    }

    public final List getNewFiles() {
        return this.newFiles;
    }

    public final List getChangedFiles() {
        return this.changedFiles;
    }

    public final List getDeletedFiles() {
        return this.deletedFiles;
    }

    public final List getUnchangedFiles() {
        return this.unchangedFiles;
    }

    public final List getDecompressFiles() {
        return this.decompressFiles;
    }

    public final List getClasspathJarFiles() {
        return this.classpathJarFiles;
    }

    public final boolean isUpdateNecessary() {
        return this.newFiles.size() + this.changedFiles.size() + this.deletedFiles.size() > 0;
    }
}

