/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.net.URL;
import org.fuin.kickstart4j.FileLoader;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.Kickstart4JConfig;
import org.fuin.kickstart4j.Kickstart4JConfigParser;
import org.fuin.kickstart4j.LoadingFileException;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.kickstart4j.SrcFileNotFoundException;
import org.fuin.kickstart4j.Utils;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.progress.FileCopyProgressListener;

public final class SrcFileLoader
implements FileLoader {
    private final Kickstart4JConfig config;

    public SrcFileLoader(String configFileURL) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"configFileURL", (Object)configFileURL);
        this.config = Kickstart4JConfigParser.create(configFileURL);
    }

    public SrcFileLoader(Kickstart4JConfig config) {
        Utils4J.checkNotNull((String)"config", (Object)config);
        this.config = config;
    }

    public final Kickstart4JConfig getConfig() {
        return this.config;
    }

    public void loadFile(File file) throws LoadingFileException {
        this.loadFile(file, null);
    }

    public void loadFile(File file, FileCopyProgressListener listener) throws LoadingFileException {
        Utils4J.checkNotNull((String)"file", (Object)file);
        Utils4J.checkValidDir((File)file.getParentFile());
        try {
            SrcFile srcFile = this.config.findSrcFile(file);
            URL srcFileUrl = srcFile.getUrl(this.config.getSrcUrl());
            File destFile = srcFile.getDestFile(this.config.getDestDir());
            if (destFile.exists()) {
                String destHash = Utils4J.createHash((File)destFile);
                if (!srcFile.getMd5Hash().equals(destHash)) {
                    Utils.copyURLToFile(listener, srcFileUrl, destFile, 1, srcFile.getSizeAsInt());
                }
            } else {
                Utils.copyURLToFile(listener, srcFileUrl, destFile, 1, srcFile.getSizeAsInt());
            }
        }
        catch (SrcFileNotFoundException ex) {
            throw new LoadingFileException("Unknown file '" + file + "'!", ex);
        }
        catch (RuntimeException ex) {
            throw new LoadingFileException("Error loading file '" + file + "'!", ex);
        }
    }
}

