/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.net.URL;
import org.fuin.kickstart4j.AbstractFile;
import org.fuin.utils4j.Utils4J;

public final class SrcFile
extends AbstractFile {
    public static final String UNZIP_TOKEN = "UNZIP";
    private final long size;
    private final boolean unzip;
    private final boolean loadAlways;
    private final boolean addToClasspath;

    public SrcFile(File baseDir, File file, boolean unzip, boolean loadAlways, boolean addToClasspath) {
        super(baseDir, file);
        this.size = file.length();
        this.unzip = unzip;
        this.loadAlways = loadAlways;
        this.addToClasspath = addToClasspath;
    }

    public SrcFile(String path, String filename, String md5Hash, long size, boolean unzip, boolean loadAlways, boolean addToClasspath) {
        super(path, filename, md5Hash);
        this.size = size;
        this.unzip = unzip;
        this.loadAlways = loadAlways;
        this.addToClasspath = addToClasspath;
    }

    public final long getSize() {
        return this.size;
    }

    public final int getSizeAsInt() {
        if (this.size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.size;
    }

    public final boolean isUnzip() {
        return this.unzip;
    }

    public final URL getUrl(URL srcUrl) {
        return Utils4J.createUrl((URL)srcUrl, (String)this.getPath().replace(File.separatorChar, '/'), (String)this.getFilename());
    }

    public final boolean isAddToClasspath() {
        return this.addToClasspath;
    }

    public final boolean isLoadAlways() {
        return this.loadAlways;
    }

    public final String toXML() {
        return "<file path=\"" + this.getSlashPath() + "\" file=\"" + this.getFilename() + "\" hash=\"" + this.getMd5Hash() + "\" size=\"" + this.size + "\" unzip=\"" + this.unzip + "\" loadAlways=\"" + this.loadAlways + "\" addToClasspath=\"" + this.addToClasspath + "\"/>";
    }

    public final String toString() {
        return this.toXML();
    }
}

