/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.fuin.utils4j.Utils4J;

public final class Kickstart4JMessages {
    private static final String DEFAULT_MESSAGES = "messages";
    private final Properties props;

    Kickstart4JMessages(Locale locale) {
        ResourceBundle res = ResourceBundle.getBundle(Utils4J.getPackagePath(this.getClass()) + "/" + DEFAULT_MESSAGES, locale);
        Properties defaultProperties = new Properties();
        Enumeration<String> enu = res.getKeys();
        while (enu.hasMoreElements()) {
            String key = enu.nextElement();
            String value = res.getString(key);
            defaultProperties.put(key, value);
        }
        this.props = defaultProperties;
    }

    Kickstart4JMessages(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("The argument 'props' cannot be null!");
        }
        this.props = props;
    }

    public final String getUpdateAvailable() {
        return this.props.getProperty("update-available");
    }

    public final String getProgressMonitorTitle() {
        return this.props.getProperty("progress-monitor-title");
    }

    public final String getProgressMonitorTransferText() {
        return this.props.getProperty("progress-monitor-transfertext");
    }

    public final String getProgressMonitorSrcLabelText() {
        return this.props.getProperty("progress-monitor-srclabeltext");
    }

    public final String getProgressMonitorDestLabelText() {
        return this.props.getProperty("progress-monitor-destlabeltext");
    }

    public final String getProgressMonitorDecompressText() {
        return this.props.getProperty("progress-monitor-decompresstext");
    }

    public final String getSelectDestinationDirectory() {
        return this.props.getProperty("select-destination-directory");
    }

    public final String getOperationCanceled() {
        return this.props.getProperty("operation-canceled");
    }

    public final String getOptionUsageLnf() {
        return this.props.getProperty("option-usage-lnf");
    }

    public final String getOptionUsageExit() {
        return this.props.getProperty("option-usage-exit");
    }

    public final String getOptionUsageSrc() {
        return this.props.getProperty("option-usage-src");
    }

    public final String getOptionUsageDest() {
        return this.props.getProperty("option-usage-dest");
    }

    public final String getOptionUsageIdFilename() {
        return this.props.getProperty("option-usage-idFilename");
    }

    public final String getOptionUsageSilentInstall() {
        return this.props.getProperty("option-usage-silentInstall");
    }

    public final String getOptionUsageSilentUpdate() {
        return this.props.getProperty("option-usage-silentUpdate");
    }

    public final String getOptionUsageLocale() {
        return this.props.getProperty("option-usage-locale");
    }

    public final String getOptionRequired() {
        return this.props.getProperty("option-required");
    }

    public final String getOptionUsageLazyLoading() {
        return this.props.getProperty("option-usage-lazy-loading");
    }

    public final String getErrorMissingReuiredOptions() {
        return this.props.getProperty("error.missing-required-options");
    }

    public final String getErrorOptionWithoutPrefix(String arg) {
        return Kickstart4JMessages.replace(this.props.getProperty("error.option-without-prefix"), "$ARG", arg);
    }

    public final String getErrorValueMissingForOption(String arg) {
        return Kickstart4JMessages.replace(this.props.getProperty("error.value-missing-for-option"), "$ARG", arg);
    }

    public final String getErrorUnknownOption(String arg) {
        return Kickstart4JMessages.replace(this.props.getProperty("error.unknown-option"), "$ARG", arg);
    }

    private static final String replace(String str, String var, String val) {
        Utils4J.checkNotNull((String)"var", (Object)var);
        if (str == null || str.length() == 0) {
            return str;
        }
        int p = str.indexOf(var);
        if (p == -1) {
            return str;
        }
        if (val == null) {
            return str.substring(0, p) + str.substring(p + var.length() + 1, str.length());
        }
        return str.substring(0, p) + val + str.substring(p + var.length() + 1, str.length());
    }
}

