/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.Kickstart4JConfig;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.utils4j.Utils4J;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Kickstart4JConfigParser {
    private final ConfigHandler handler = new ConfigHandler();

    public void parse(String urlStr) throws InvalidConfigException {
        try {
            URL url = new URL(urlStr);
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.newSAXParser().parse(url.toExternalForm(), (DefaultHandler)this.handler);
            }
            catch (SAXException e) {
                throw new InvalidConfigException(url, (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new InvalidConfigException(url, (Throwable)e);
            }
            catch (IOException e) {
                throw new InvalidConfigException(url, (Throwable)e);
            }
        }
        catch (MalformedURLException ex) {
            throw new InvalidConfigException("Invalid URL '" + urlStr + "'!");
        }
    }

    public void copyToConfig(Kickstart4JConfig config) throws InvalidConfigException {
        List elements = this.handler.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            ConfigElement element = (ConfigElement)elements.get(i);
            if (element.getName().equals("file")) {
                Map atts = element.getAttributes();
                String path = (String)atts.get("path");
                Kickstart4JConfigParser.checkNotNull(element, "path", path);
                String file = (String)atts.get("file");
                Kickstart4JConfigParser.checkNotNull(element, "file", file);
                String hash = (String)atts.get("hash");
                Kickstart4JConfigParser.checkNotNull(element, "hash", hash);
                String size = (String)atts.get("size");
                Kickstart4JConfigParser.checkNotNull(element, "size", size);
                boolean unzip = Kickstart4JConfigParser.getBoolean(atts, "unzip", false);
                boolean loadAlways = Kickstart4JConfigParser.getBoolean(atts, "loadAlways", false);
                boolean addToClasspath = Kickstart4JConfigParser.getBoolean(atts, "addToClasspath", false);
                config.getSrcFiles().add(new SrcFile(path, file, hash, Long.valueOf(size), unzip, loadAlways, addToClasspath));
                continue;
            }
            config.put(element.getName(), element.getText());
        }
    }

    private static void checkNotNull(ConfigElement element, String attrName, String attrValue) throws InvalidConfigException {
        if (attrValue == null) {
            throw new InvalidConfigException("Element '" + element.getName() + "' missing required attribute '" + attrName + "'!");
        }
    }

    private static boolean getBoolean(Map atts, String key, boolean defaultValue) {
        String value = (String)atts.get(key);
        if (value == null) {
            return defaultValue;
        }
        String str = value.trim();
        if (str.length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(str);
    }

    public static Kickstart4JConfig parse(Kickstart4JConfig config, String configFileURL) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"config", (Object)config);
        Utils4J.checkNotNull((String)"configFileURL", (Object)configFileURL);
        Kickstart4JConfigParser parser = new Kickstart4JConfigParser();
        parser.parse(configFileURL);
        parser.copyToConfig(config);
        return config;
    }

    public static Kickstart4JConfig create(String configFileURL) throws InvalidConfigException {
        Utils4J.checkNotNull((String)"configFileURL", (Object)configFileURL);
        return Kickstart4JConfigParser.parse(new Kickstart4JConfig(), configFileURL);
    }

    public static Kickstart4JConfig create(File configFile) throws InvalidConfigException {
        try {
            return Kickstart4JConfigParser.create(configFile.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Error creating file URL!", ex);
        }
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private final List elements = new ArrayList();
        private ConfigElement element = null;
        private int level = 0;

        private ConfigHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.level == 1) {
                this.element = new ConfigElement(qName, atts);
                this.elements.add(this.element);
            }
            ++this.level;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.level == 2 && this.element != null) {
                this.element.setText(String.copyValueOf(ch, start, length));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.level == 1) {
                this.element = null;
            }
            --this.level;
        }

        public List getElements() {
            return this.elements;
        }
    }

    private static final class ConfigElement {
        private final String name;
        private final Map attributes;
        private String text = null;

        public ConfigElement(String name, Attributes atts) {
            this.name = name;
            this.attributes = new HashMap();
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                this.attributes.put(atts.getQName(i), atts.getValue(i));
            }
        }

        public final Map getAttributes() {
            return this.attributes;
        }

        public final String getName() {
            return this.name;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            if (text == null) {
                this.text = null;
            } else {
                this.text = text.trim();
                if (this.text.length() == 0) {
                    this.text = null;
                }
            }
        }

        public final boolean getTextAsBoolean() {
            if (this.text == null || this.text.length() == 0) {
                return false;
            }
            return Boolean.valueOf(this.text);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name);
            sb.append("=");
            sb.append(this.text);
            sb.append(" {");
            int count = 0;
            Iterator it = this.attributes.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)this.attributes.get(key);
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(key);
                sb.append("=");
                sb.append(value);
                ++count;
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

