/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.Kickstart4JMessages;
import org.fuin.kickstart4j.OptionNotFoundException;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.kickstart4j.SrcFileNotFoundException;
import org.fuin.utils4j.Utils4J;

public final class Kickstart4JConfig {
    private String lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
    private String idFilename;
    private boolean exitAfterExecute = true;
    private URL srcUrl = null;
    private File destDir = null;
    private boolean silentInstall = false;
    private boolean silentUpdate = false;
    private boolean firstInstallation = true;
    private Locale locale = Locale.getDefault();
    private String msgFile = null;
    private Kickstart4JMessages messages = null;
    private boolean lazyLoading = false;
    private Map userDefinedOptions = new HashMap();
    private String javaExe = null;
    private String javaArgs = null;
    private String title = null;
    private String vendor = null;
    private String description = null;
    private List srcFiles = new ArrayList();
    private String configFileUrlStr = null;
    private String version = null;

    public final String getLookAndFeelClassName() {
        return this.lookAndFeelClassName;
    }

    public final void setLookAndFeelClassName(String lnfClassName) {
        this.lookAndFeelClassName = lnfClassName == null ? UIManager.getSystemLookAndFeelClassName() : lnfClassName;
    }

    public final boolean isExitAfterExecute() {
        return this.exitAfterExecute;
    }

    public final void setExitAfterExecute(boolean exitAfterExecute) {
        this.exitAfterExecute = exitAfterExecute;
    }

    public final URL getSrcUrl() {
        return this.srcUrl;
    }

    public final void setSrcUrl(URL srcUrl) {
        if (srcUrl == null) {
            throw new IllegalArgumentException("The argument 'srcUrl' cannot be null!");
        }
        this.srcUrl = srcUrl;
    }

    public final void setSrcUrl(String srcUrl) {
        if (srcUrl == null) {
            throw new IllegalArgumentException("The argument 'srcUrl' cannot be null!");
        }
        try {
            this.srcUrl = new URL(srcUrl);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("The argument 'srcUrl' is not a valid URL [" + srcUrl + "]!", ex);
        }
    }

    public final File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        if (destDir == null) {
            throw new IllegalArgumentException("The argument 'destDir' cannot be null!");
        }
        this.destDir = destDir;
    }

    public final void setDestPath(String destPath) {
        if (destPath == null) {
            throw new IllegalArgumentException("The argument 'destPath' cannot be null!");
        }
        this.destDir = new File(destPath);
    }

    public final String getIdFilename() {
        return this.idFilename;
    }

    public final void setIdFilename(String id) {
        if (id == null) {
            throw new IllegalArgumentException("The argument 'id' cannot be null!");
        }
        this.idFilename = id;
    }

    public final boolean isSilentInstall() {
        return this.silentInstall;
    }

    public final void setSilentInstall(boolean silentInstall) {
        this.silentInstall = silentInstall;
    }

    public final boolean isSilentUpdate() {
        return this.silentUpdate;
    }

    public final void setSilentUpdate(boolean silentUpdate) {
        this.silentUpdate = silentUpdate;
    }

    public final boolean isFirstInstallation() {
        return this.firstInstallation;
    }

    public final void setFirstInstallation(boolean firstInstallation) {
        this.firstInstallation = firstInstallation;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    public final void setLocale(String locale) {
        if (locale == null) {
            this.locale = Locale.getDefault();
        } else {
            String variant;
            String country;
            String language;
            StringTokenizer tok = new StringTokenizer(locale, ",");
            int count = tok.countTokens();
            if (count == 1) {
                language = tok.nextToken();
                country = "";
                variant = "";
            } else if (count == 2) {
                language = tok.nextToken();
                country = tok.nextToken();
                variant = "";
            } else if (count == 3) {
                language = tok.nextToken();
                country = tok.nextToken();
                variant = tok.nextToken();
            } else {
                throw new IllegalArgumentException("The argument '" + locale + "' is not valid!");
            }
            this.locale = new Locale(language, country, variant);
        }
    }

    public final String getMsgFile() {
        return this.msgFile;
    }

    public final void setMsgFile(String msgFile) {
        this.msgFile = msgFile == null ? null : msgFile.trim();
    }

    public final void check() throws InvalidConfigException {
        if (this.destDir == null) {
            throw new InvalidConfigException("The 'destDir' is null!");
        }
        if (this.srcUrl == null) {
            throw new InvalidConfigException("The 'srcUrl' is null!");
        }
        if (this.idFilename == null) {
            throw new InvalidConfigException("The 'idFilename' is null!");
        }
        if (this.lazyLoading && (this.configFileUrlStr == null || this.configFileUrlStr.trim().length() == 0)) {
            throw new InvalidConfigException("The 'configFileUrlStr' is null or empty!");
        }
    }

    public final Kickstart4JMessages getMessages() {
        if (this.messages == null) {
            try {
                this.messages = new Kickstart4JMessages(Utils4J.loadProperties((URL)this.getSrcUrl(), (String)this.getMsgFile()));
            }
            catch (RuntimeException ex) {
                this.messages = new Kickstart4JMessages(this.locale);
            }
        }
        return this.messages;
    }

    public final boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public final void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    public final void addUserDefinedOption(String key, String value) {
        this.userDefinedOptions.put(key, value);
    }

    public final String getUserDefinedOption(String key) throws OptionNotFoundException {
        return (String)this.userDefinedOptions.get(key);
    }

    public final Map getUserDefinedOptions() {
        return this.userDefinedOptions;
    }

    public final String getJavaArgs() {
        return this.javaArgs;
    }

    public final void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    public final String getJavaExe() {
        return this.javaExe;
    }

    public final void setJavaExe(String javaExe) {
        this.javaExe = javaExe;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public final String getVendor() {
        return this.vendor;
    }

    public final void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public final List getSrcFiles() {
        return this.srcFiles;
    }

    public final String getConfigFileUrlStr() {
        return this.configFileUrlStr;
    }

    public final void setConfigFileUrlStr(String configFileUrlStr) {
        this.configFileUrlStr = configFileUrlStr;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final SrcFile findSrcFile(File file) throws SrcFileNotFoundException {
        try {
            String pathAndFilename = file.getCanonicalPath();
            for (int i = 0; i < this.srcFiles.size(); ++i) {
                SrcFile srcFile = (SrcFile)this.srcFiles.get(i);
                String destPathAndFilename = srcFile.getCanonicalPathAndFilename(this.destDir);
                if (!pathAndFilename.equals(destPathAndFilename)) continue;
                return srcFile;
            }
            throw new SrcFileNotFoundException(Utils4J.getRelativePath((File)this.destDir, (File)file.getParentFile()), file.getName());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void put(String key, String value) {
        if (key.equals("title")) {
            this.setTitle(value);
        } else if (key.equals("vendor")) {
            this.setVendor(value);
        } else if (key.equals("description")) {
            this.setDescription(value);
        } else if (key.equals("exitAfterExecute")) {
            this.setExitAfterExecute(this.toBoolean(value));
        } else if (key.equals("destPath")) {
            this.setDestPath(value);
        } else if (key.equals("idFilename")) {
            this.setIdFilename(value);
        } else if (key.equals("silentInstall")) {
            this.setSilentInstall(this.toBoolean(value));
        } else if (key.equals("silentUpdate")) {
            this.setSilentUpdate(this.toBoolean(value));
        } else if (key.equals("locale")) {
            this.setLocale(value);
        } else if (key.equals("lazyLoading")) {
            this.setLazyLoading(this.toBoolean(value));
        } else if (key.equals("javaExe")) {
            this.setJavaExe(value);
        } else if (key.equals("javaArgs")) {
            this.setJavaArgs(value);
        } else if (key.equals("srcUrl")) {
            this.setSrcUrl(value);
        } else if (key.equals("version")) {
            this.setVersion(value);
        } else {
            this.addUserDefinedOption(key, value);
        }
    }

    private boolean toBoolean(String str) {
        if (str == null) {
            return false;
        }
        String trimmed = str.trim();
        if (trimmed.length() == 0) {
            return false;
        }
        return Boolean.valueOf(trimmed);
    }

    public final String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<application>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <version>" + this.version + "</version>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <title>" + this.title + "</title>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <vendor>" + this.vendor + "</vendor>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <description>" + this.description + "</description>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <exitAfterExecute>" + this.exitAfterExecute + "</exitAfterExecute>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <srcUrl>" + this.srcUrl + "</srcUrl>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <destPath>" + this.destDir + "</destPath>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <idFilename>" + this.idFilename + "</idFilename>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <silentInstall>" + this.silentInstall + "</silentInstall>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <silentUpdate>" + this.silentUpdate + "</silentUpdate>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <locale>" + this.locale + "</locale>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <lazyLoading>" + this.lazyLoading + "</lazyLoading>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <javaExe>" + this.javaExe + "</javaExe>" + IOUtils.LINE_SEPARATOR);
        sb.append("  <javaArgs>" + this.javaArgs + "</javaArgs>" + IOUtils.LINE_SEPARATOR);
        for (int i = 0; i < this.srcFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)this.srcFiles.get(i);
            sb.append("  " + srcFile.toXML() + IOUtils.LINE_SEPARATOR);
        }
        sb.append("</application>" + IOUtils.LINE_SEPARATOR);
        return sb.toString();
    }

    public final String toString() {
        return this.toXML();
    }
}

