/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.launcher.CommandLauncher;
import org.apache.commons.exec.launcher.CommandLauncherFactory;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.Kickstart4JConfig;
import org.fuin.kickstart4j.Kickstart4JConfigParser;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.kickstart4j.UpdateSet;
import org.fuin.kickstart4j.Utils;
import org.fuin.utils4j.Cancelable;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.common.Utils4Swing;
import org.fuin.utils4swing.dialogs.CanceledException;
import org.fuin.utils4swing.dialogs.DirectorySelector;
import org.fuin.utils4swing.progress.FileCopyProgressListener;
import org.fuin.utils4swing.progress.FileCopyProgressMonitor;
import org.fuin.utils4swing.threadsafe.ThreadSafeJOptionPane;

public final class Kickstart4J {
    private static final String INCOMPLETE_FILE = ".incomplete";
    private static final String PROGRAM_DIRECTORY_KEY = "program-directory";
    private final Kickstart4JConfig config;

    public Kickstart4J(Kickstart4JConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The argument 'config' cannot be null!");
        }
        this.config = config;
    }

    public final void execute() throws CanceledException, InvalidConfigException {
        Locale.setDefault(this.config.getLocale());
        File destDir = this.getDestDir();
        this.config.check();
        UpdateSet updateSet = new UpdateSet(this.config.getSrcFiles(), destDir, this.config.isLazyLoading());
        if (updateSet.isUpdateNecessary() && (this.config.isSilentUpdate() || this.config.isFirstInstallation() || Kickstart4J.isAnswerYes(this.config.getMessages().getUpdateAvailable()))) {
            this.execute(updateSet);
            File installationIncompleteFile = new File(destDir, INCOMPLETE_FILE);
            if (installationIncompleteFile.exists()) {
                installationIncompleteFile.delete();
            }
        }
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("classpath", this.createClasspath(updateSet));
        varMap.put("configFileUrl", this.config.getConfigFileUrlStr());
        varMap.putAll(this.config.getUserDefinedOptions());
        CommandLine commandLine = new CommandLine(new File(this.config.getDestDir(), this.config.getJavaExe()));
        commandLine.setSubstitutionMap(varMap);
        commandLine.addArguments(this.config.getJavaArgs(), false);
        this.logStart(destDir, commandLine.toString());
        this.startExternal(destDir, commandLine);
    }

    private String createClasspath(UpdateSet updateSet) {
        List cpJarFiles = updateSet.getClasspathJarFiles();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cpJarFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)cpJarFiles.get(i);
            if (i > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append("\"");
            sb.append(srcFile.getRelativeSlashPathAndFilename());
            sb.append("\"");
        }
        return sb.toString();
    }

    private File getIdFile(Kickstart4JConfig config) {
        return new File(Utils4J.getUserHomeDir(), config.getIdFilename());
    }

    private void execute(UpdateSet updateSet) throws CanceledException {
        this.executeCopy(updateSet);
        this.executeDecompress(updateSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCopy(UpdateSet updateSet) throws CanceledException {
        int max = updateSet.getNewFiles().size() + updateSet.getChangedFiles().size();
        if (max > 0) {
            Cancelable cancelable = new Cancelable(){
                private volatile boolean canceled = false;

                public void cancel() {
                    this.canceled = true;
                }

                public boolean isCanceled() {
                    return this.canceled;
                }
            };
            FileCopyProgressMonitor monitor = new FileCopyProgressMonitor(cancelable, this.config.getMessages().getProgressMonitorTitle(), this.config.getMessages().getProgressMonitorTransferText(), this.config.getMessages().getProgressMonitorSrcLabelText(), this.config.getMessages().getProgressMonitorDestLabelText(), max);
            int count = 0;
            monitor.open();
            try {
                if (cancelable.isCanceled()) {
                    throw new CanceledException();
                }
                count = this.copyFiles(updateSet, cancelable, (FileCopyProgressListener)monitor, updateSet.getNewFiles(), count);
                if (cancelable.isCanceled()) {
                    throw new CanceledException();
                }
                count = this.copyFiles(updateSet, cancelable, (FileCopyProgressListener)monitor, updateSet.getChangedFiles(), count);
                if (cancelable.isCanceled()) {
                    throw new CanceledException();
                }
                for (int i = 0; i < updateSet.getDeletedFiles().size(); ++i) {
                    if (cancelable.isCanceled()) {
                        break;
                    }
                    String file = (String)updateSet.getDeletedFiles().get(i);
                    File destFile = new File(updateSet.getDestDir(), file);
                    monitor.updateFile("", destFile.toString(), ++count, 0);
                }
            }
            finally {
                monitor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDecompress(UpdateSet updateSet) throws CanceledException {
        List compressedFiles = updateSet.getDecompressFiles();
        int max = compressedFiles.size();
        if (max > 0) {
            Cancelable cancelable = new Cancelable(){
                private volatile boolean canceled = false;

                public void cancel() {
                    this.canceled = true;
                }

                public boolean isCanceled() {
                    return this.canceled;
                }
            };
            FileCopyProgressMonitor monitor = new FileCopyProgressMonitor(cancelable, this.config.getMessages().getProgressMonitorTitle(), this.config.getMessages().getProgressMonitorDecompressText(), this.config.getMessages().getProgressMonitorSrcLabelText(), this.config.getMessages().getProgressMonitorDestLabelText(), max);
            monitor.open();
            try {
                for (int i = 0; i < max; ++i) {
                    SrcFile file = (SrcFile)compressedFiles.get(i);
                    File compressedFile = file.getDestFile(updateSet.getDestDir());
                    Utils.unzip((FileCopyProgressListener)monitor, compressedFile, i + 1, updateSet.getDestDir(), cancelable);
                }
            }
            finally {
                monitor.close();
            }
        }
    }

    private int copyFiles(UpdateSet updateSet, Cancelable cancelable, FileCopyProgressListener listener, List files, int total) {
        int count = total;
        for (int i = 0; i < files.size() && !cancelable.isCanceled(); ++i) {
            SrcFile file = (SrcFile)files.get(i);
            URL srcFileUrl = file.getUrl(this.config.getSrcUrl());
            File destFile = file.getDestFile(updateSet.getDestDir());
            Utils.copyURLToFile(listener, srcFileUrl, destFile, ++count, file.getSizeAsInt());
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStart(File dir, String commandLine) {
        try {
            File file = new File(dir, "start.log");
            FileWriter writer = new FileWriter(file);
            try {
                writer.write(commandLine);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void startExternal(File destDir, CommandLine commandLine) {
        CommandLauncher launcher = CommandLauncherFactory.createVMLauncher();
        try {
            launcher.exec(commandLine, null, destDir);
            System.exit(0);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private File getDestDir() throws CanceledException {
        File installationIncompleteFile;
        File dir;
        File idFile = this.getIdFile(this.config);
        if (idFile.exists()) {
            Properties props = Utils4J.loadProperties((File)idFile);
            String dirStr = props.getProperty(PROGRAM_DIRECTORY_KEY);
            if (dirStr == null) {
                throw new IllegalStateException("The property 'program-directory' was not found inside '" + idFile + "'!");
            }
            dir = new File(dirStr);
            Utils4J.checkValidDir((File)dir);
            installationIncompleteFile = new File(dir, INCOMPLETE_FILE);
        } else {
            Properties props = new Properties();
            String dirStr = this.config.isSilentInstall() ? this.config.getDestDir().toString() : DirectorySelector.selectDirectory((String)this.config.getMessages().getSelectDestinationDirectory(), (String)this.config.getDestDir().toString()).getDirectory();
            props.setProperty(PROGRAM_DIRECTORY_KEY, dirStr);
            Utils4J.saveProperties((File)idFile, (Properties)props, (String)"# --- DO NOT EDIT --- Generated by Kickstart4J ---");
            dir = new File(dirStr);
            installationIncompleteFile = new File(dir, INCOMPLETE_FILE);
            if (!dir.exists()) {
                try {
                    dir.mkdirs();
                    installationIncompleteFile.createNewFile();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Cannot create file '" + installationIncompleteFile + "'!");
                }
            }
        }
        this.config.setFirstInstallation(installationIncompleteFile.exists());
        return dir;
    }

    private static void initLookAndFeel(final String lookAndFeelClassName) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Utils4Swing.initLookAndFeel((String)lookAndFeelClassName);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isAnswerYes(String message) {
        int result = ThreadSafeJOptionPane.showConfirmDialog(null, (Object)message, (String)"TITLE", (int)0, (int)3);
        return result == 0;
    }

    private static void showError(String message) {
        ThreadSafeJOptionPane.showMessageDialog(null, (Object)message, (String)"Error", (int)0);
    }

    private static void showMessage(String message) {
        ThreadSafeJOptionPane.showMessageDialog(null, (Object)message, (String)"Hint", (int)1);
    }

    private static void displayCmdLine() {
        String msg = "java Kickstart4J <CONFIG-FILE-URL>";
        System.out.println("java Kickstart4J <CONFIG-FILE-URL>");
        Kickstart4J.showError("java Kickstart4J <CONFIG-FILE-URL>");
    }

    private static void displayException(Exception ex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(out));
        String msg = out.toString();
        System.err.println(msg);
        Kickstart4J.showError(msg);
    }

    private static File createLocalConfigFile() {
        try {
            return File.createTempFile("application-", ".xml");
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot create local config file!", ex);
        }
    }

    private static String toUrlString(File localConfigFile) {
        try {
            return localConfigFile.toURI().toURL().toString();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Cannot create local config file URL!", ex);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            Kickstart4J.displayCmdLine();
            return;
        }
        String remoteConfigFileUrlStr = args[0].trim();
        try {
            File localConfigFile = Kickstart4J.createLocalConfigFile();
            String localConfigFileUrlStr = Kickstart4J.toUrlString(localConfigFile);
            Utils.copyURLToFile(remoteConfigFileUrlStr, localConfigFile);
            Kickstart4JConfig config = new Kickstart4JConfig();
            try {
                Kickstart4JConfigParser.parse(config, localConfigFileUrlStr);
                config.setConfigFileUrlStr(localConfigFileUrlStr);
                Kickstart4J.initLookAndFeel(config.getLookAndFeelClassName());
                new Kickstart4J(config).execute();
            }
            catch (CanceledException ex) {
                Kickstart4J.showMessage(config.getMessages().getOperationCanceled());
                System.exit(0);
            }
            catch (InvalidConfigException ex) {
                Kickstart4J.showMessage(ex.getMessage());
                System.exit(0);
            }
        }
        catch (RuntimeException ex) {
            Kickstart4J.displayException(ex);
            System.exit(0);
        }
    }
}

