/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.kickstart4j;

import java.io.File;

import org.fuin.utils4swing.progress.FileCopyProgressListener;

/**
 * Supports loading files from a source location into a local directory.
 */
public interface FileLoader {

    /**
     * Loads a file from a source into a local directory. If the file is already
     * up to date nothing will be copied.
     * 
     * @param file
     *            File inside the base directory - Cannot be <code>null</code>.
     * 
     * @throws LoadingFileException
     *             Loading the file failed for some reason.
     */
    public void loadFile(File file) throws LoadingFileException;

    /**
     * Loads a file from a source into a local directory. If the file is already
     * up to date nothing will be copied. The listener will be informed about
     * loading progress.
     * 
     * @param file
     *            File inside the base directory.
     * @param listener
     *            Listener to inform about progress - Can be <code>null</code>
     *            if no progress information is needed.
     * 
     * @throws LoadingFileException
     *             Loading the file failed for some reason.
     */
    public void loadFile(File file, FileCopyProgressListener listener) throws LoadingFileException;

}
