/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.jmsmvc4swing.jms;

import org.fuin.jmsmvc4swing.base.Controller;

/**
 * Handles a method call.
 */
public interface MethodHandler {

    /**
     * Returns the method name this handler belongs to.
     * 
     * @return Method name.
     */
    public String getMethodName();

    /**
     * Calls a method on the given controller.
     * 
     * @param controller
     *            Controller to use.
     * @param topicName
     *            Topic to publish the result to.
     * @param args
     *            Arguments for the method call.
     * @param id
     *            Unique method call id.
     */
    public void handle(Controller controller, String topicName, Data args, long id);

}
